import apiClient from "@/lib/apiClient";

export type Meeting = {
  id: string;
  case_id: string | null;
  title: string;
  starts_at: string;
  ends_at: string | null;
  location: string | null;
  created_by: string | null;
  created_at: string;
  updated_at: string;
};

export type AgendaItem = {
  id: string;
  meeting_id: string;
  title: string;
  description: string | null;
  thread_id: string | null;
  decision_id: string | null;
  sort_order: number;
  created_at: string;
};

export const meetingsApi = {
  create: (payload: {
    title: string;
    startsAt: string; // ISO
    endsAt?: string; // ISO
    location?: string;
    caseId?: string;
  }) => apiClient.post<{ id: string }>(`/api/admin/meetings`, payload),

  detail: (meetingId: string) =>
    apiClient.get<{ meeting: Meeting; agenda: AgendaItem[] }>(
      `/api/admin/meetings/${meetingId}`
    ),

  addAgenda: (
    meetingId: string,
    payload: {
      title: string;
      description?: string;
      threadId?: string;
      decisionId?: string;
      sortOrder?: number;
    }
  ) =>
    apiClient.post<{ id: string }>(
      `/api/admin/meetings/${meetingId}/agenda`,
      payload
    ),
};

export default meetingsApi;
