// src/routes/attachments.ts
import apiClient from "@/lib/apiClient";

export const attachmentsApi = {
  uploadToThread: (threadId: string, file: File) => {
    const form = new FormData();
    form.append("file", file);

    return apiClient.post<{ id: string }>(
      `/api/admin/attachments/thread/${threadId}`,
      form,
      { headers: { "Content-Type": "multipart/form-data" } }
    );
  },

  // downloadUrl-t már visszaadja listAttachments, de ha kell:
  downloadUrl: (attachmentId: string) =>
    `/api/admin/attachments/${attachmentId}/download`,
};

export default attachmentsApi;
