import Cookies from "js-cookie";

const postData = async function (
  url = "",
  method = "GET",
  token = null,
  data = {},
  type = "application/json"
) {
  const sid = Cookies.get("edSId"); // Retrieve the sid from the cookie
  const headers = {
    "Content-Type": type ? type : "application/json",
    "User-Type": "edit",
  };

  if (sid) {
    headers["x-sid"] = sid;
  }
  if (token) {
    headers.Authorization = `Bearer ${token}`;
  }

  const options = {
    method,
    mode: "cors",
    cache: "no-cache",
    credentials: process.env.NODE_ENV === "development" ? "include" : "include",
    withCredentials: true,
    headers,
    redirect: "follow",
    referrerPolicy: "no-referrer",
  };

  if (method !== "GET") {
    if (type === "application/json") {
      options.body = JSON.stringify(data);
    } else if (
      type === "multipart/form-data" ||
      type === "multipart/mixed" ||
      type === "application/x-www-form-urlencoded" ||
      type === "application/octet-stream"
    ) {
      options.body = data;
    }
  }

  try {
    const response = await fetch(url, options);
    const result = await response.json();
    if (!response.ok) {
      throw new Error(result.message || "Something went wrong");
    }
    return result;
  } catch (error) {
    console.error("API error:", error);
    throw error; // Propagate the error
  }
};

export default postData;
