function slugifyTitle(title: string): string {
  return (
    title
      .toLowerCase()
      .trim()
      // replace accents (basic normalization)
      .normalize("NFD")
      .replace(/[\u0300-\u036f]/g, "")
      // replace anything not a-z0-9 with -
      .replace(/[^a-z0-9]+/g, "-")
      // collapse multiple -
      .replace(/-+/g, "-")
      // trim leading/trailing -
      .replace(/^-|-$/g, "") || "faq"
  );
}

function timestampForFilename(date: Date = new Date()): string {
  const pad = (n: number) => n.toString().padStart(2, "0");
  const yyyy = date.getFullYear();
  const mm = pad(date.getMonth() + 1);
  const dd = pad(date.getDate());
  const hh = pad(date.getHours());
  const mi = pad(date.getMinutes());
  return `${yyyy}${mm}${dd}-${hh}${mi}`; // e.g. 20250130-1423
}
export { slugifyTitle, timestampForFilename };
