export const buildColumnSizeList = (inputArray, colSizeList) => {
  if (colSizeList) {
    // Create a map to store unique size values and their corresponding ids
    const uniqueSizesMap = new Map();

    for (const item of inputArray) {
      const sizeString = JSON.stringify(item.sizes[0]);

      // Check if the size value is not already in the map
      if (!uniqueSizesMap.has(sizeString)) {
        uniqueSizesMap.set(sizeString, item.id);
      }
    }

    // Convert the map back to an array of objects
    const uniqueArray = Array.from(uniqueSizesMap, ([sizes, id]) => ({
      size: JSON.parse(sizes),
    }));

    // Initialize an object to store unique size values as keys and corresponding id values as values
    var sizeIdMap = {};

    // Initialize an array to store the matching items
    var matchingItems = [];

    // Iterate through colSizeList to create the sizeIdMap
    for (const colSizeItem of colSizeList) {
      for (const columnSize of colSizeItem.columnSize) {
        const colSizeString = JSON.stringify(columnSize);
        sizeIdMap[colSizeString] = colSizeItem._id;
      }
    }

    // Iterate through uniqueArray to find matches and populate matchingItems
    for (const uniqueItem of uniqueArray) {
      const uniqueSizeString = JSON.stringify(uniqueItem.size);
      const id = sizeIdMap[uniqueSizeString];

      if (id) {
        matchingItems.push({ id, size: uniqueItem.size });
      }
    }

    return matchingItems;
  }
};
