import Cookies from "js-cookie";

export class FetchError extends Error {
  constructor(message, status) {
    super(message);
    this.name = "FetchError";
    this.status = status;
  }
}

const apiRequest = async function (
  url = "",
  method = "GET",
  token = null,
  data = {},
  type = "application/json"
) {
  const sid = Cookies.get("edSId");

  const headers = {
    "Content-Type": type,
    "User-Type": "edit",
  };

  if (sid) {
    headers["x-sid"] = sid;
  }
  if (token) {
    headers.Authorization = `Bearer ${token}`;
  }

  const options = {
    method,
    mode: "cors",
    cache: "no-cache",
    credentials: "include", // ✅ Keep this, remove withCredentials
    headers,
    redirect: "follow",
    referrerPolicy: "no-referrer",
  };

  if (method !== "GET") {
    options.body = type === "application/json" ? JSON.stringify(data) : data;
  }

  try {
    const response = await fetch(url, options);
    if (!response.ok) {
      return response;
      // throw new Error(result.message || "Something went wrong");
    }
    return await response.json();
  } catch (error) {
    console.error("API error:", error);
    throw error;
  }
};

export default apiRequest;
