import { combineReducers } from "redux";
import { configureStore } from "@reduxjs/toolkit";
import { TypedUseSelectorHook, useDispatch, useSelector } from "react-redux";

// slices
import pageEditorReducer from "./slices/pageEditorSlice";
import orderDataReducer from "./slices/orderDataSlice";
import peopleDataReducer from "./slices/peopleSlice";
import productCategoryDataReducer from "./slices/productCategorySlice";
import productGroupReducer from "./slices/productGroupSlice";
import productItemReducer from "./slices/productItemSlice";
import uploadLogSliceReducer from "./slices/uploadLogSlice";
import productBrandSlice from "./slices/productBrandSlice";
import staticPageReducer from "./slices/staticPageEditorSlice";
import articleEditorSlice from "./slices/articleEditorSlice";
import themeConfigSlice from "./slices/themeConfigSlice";

// 1) root reducer
export const rootReducer = combineReducers({
  // Editor domains
  pageEditor: pageEditorReducer,

  // Product/Content domains
  orderData: orderDataReducer,
  peopleData: peopleDataReducer,
  productCategory: productCategoryDataReducer,
  productGroup: productGroupReducer,
  productItem: productItemReducer,
  uploadLog: uploadLogSliceReducer,
  productBrand: productBrandSlice,
  staticPageData: staticPageReducer,
  articleEditor: articleEditorSlice,

  // UI
  themeConfig: themeConfigSlice,
});

// 2) RootState type for useSelector etc.
export type IRootState = ReturnType<typeof rootReducer>;

// 3) store factory (handy for SSR/Next.js)
export const makeStore = (preloadedState?: Partial<IRootState>) =>
  configureStore({
    reducer: rootReducer,
    preloadedState: preloadedState as IRootState | undefined,
    devTools: { name: "PortableWeb CMS" },
    middleware: (getDefaultMiddleware) => getDefaultMiddleware(),
  });

// 4) Optional singleton store (useful for CSR-only apps)
export const store = makeStore();

// 5) Inferred types & typed hooks
export type AppStore = ReturnType<typeof makeStore>;
export type AppDispatch = typeof store.dispatch;

// Typed hooks (preferred)
export const useAppDispatch: () => AppDispatch = useDispatch;
export const useAppSelector: TypedUseSelectorHook<IRootState> = useSelector;

// import { combineReducers } from "redux";
// import { configureStore } from "@reduxjs/toolkit";
// import { useDispatch } from "react-redux";
// import pageEditorReducer from "./slices/pageEditorSlice";
// import orderDataReducer from "./slices/orderDataSlice";
// import peopleDataReducer from "./slices/peopleSlice";
// import productCategoryDataReducer from "./slices/productCategorySlice";
// import productGroupReducer from "./slices/productGroupSlice";
// import productItemReducer from "./slices/productItemSlice";
// import uploadLogSliceReducer from "./slices/uploadLogSlice";
// import productBrandSlice from "./slices/productBrandSlice";
// import staticPageReducer from "./slices/staticPageEditorSlice";
// import articleEditorSlice from "./slices/articleEditorSlice";
// import themeConfigSlice from "@/store/slices/themeConfigSlice";
// // Placeholder reducer
// const dummyReducer = (state = {}, action) => state;

// // Create the Redux store
// export const makeStore = () => {
//   const reducer = combineReducers({
//     // Editor domains
//     pageEditor: pageEditorReducer,
//     // Product/Content domains
//     orderData: orderDataReducer,
//     peopleData: peopleDataReducer,
//     productCategory: productCategoryDataReducer,
//     productGroup: productGroupReducer,
//     productItem: productItemReducer,
//     uploadLog: uploadLogSliceReducer,
//     productBrand: productBrandSlice,
//     staticPageData: staticPageReducer,
//     articleEditor: articleEditorSlice,
//     themeConfig: themeConfigSlice,
//   });

//   return configureStore({
//     reducer,
//     devTools: {
//       name: "PortableWeb CMS",
//     },
//     middleware: (getDefaultMiddleware) => getDefaultMiddleware().concat(),
//   });
// };

// // Create a custom hook for dispatch
// export const useAppDispatch = () => useDispatch();
