// redux/peopleSlice.js

import { createSlice } from "@reduxjs/toolkit";
import {
  createGallerySlice,
  galleryInitialState,
} from "../factory/gallerySliceFactory";

// Custom-specific initial state
const customInitialState = {
  featuredDocument: [],
  locations: [],
  specializations: [],
  artforms: [],
  peoples: [],
  departmentTypes: [],
  departments: [],
};

// Merge gallery state into people state
const initialState = {
  ...galleryInitialState, // for featuredImage
  ...customInitialState,
};

const peopleDataSlice = createSlice({
  name: "peopleData",
  initialState,
  reducers: {
    // Custom non-gallery actions
    selectDepartmentFeaturedDocument: (state, action) => {
      state.featuredDocument = [action.payload.featuredDocument];
    },
    removeDepartmentFeaturedDocument: (state) => {
      state.featuredDocument = [];
    },
    setLocations: (state, action) => {
      state.locations = action.payload.locations;
    },
    setSpecializations: (state, action) => {
      state.specializations = action.payload.specializations;
    },
    setDepartments: (state, action) => {
      state.departments = action.payload.departments;
    },
    setDepartmentTypes: (state, action) => {
      state.departmentTypes = action.payload.departmentTypes;
    },
    setArtforms: (state, action) => {
      state.artforms = action.payload.artforms;
    },
    setPeoples: (state, action) => {
      state.peoples = action.payload.peoples;
    },
    resetPeopleState: () => initialState,
  },
});

// Gallery actions
// export const galleryActions = createGallerySlice({
//   name: "peopleData",
// }).actions;

// Export custom actions
export const {
  selectDepartmentFeaturedDocument,
  removeDepartmentFeaturedDocument,
  setLocations,
  setSpecializations,
  setDepartments,
  setDepartmentTypes,
  setArtforms,
  setPeoples,
  resetPeopleState,
} = peopleDataSlice.actions;

export default peopleDataSlice.reducer;
