// store/managers/useDynamicManager.js
import useProductItemManager from "@/store/managers/useProductItemManager";
import useProductGroupManager from "@/store/managers/useProductGroupManager";
import usePageEditorManager from "@/store/managers/usePageEditorManager";
import useUploadLogManager from "@/store/managers/useUploadLogManager";
import useProductCategoryManager from "@/store/managers/useProductCategoryManager";
import useProductBrandManager from "@/store/managers/useProductBrandManager";
import useStaticPageEditorManager from "./useStaticPageEditorManager";
import useArticleEditorManager from "./useArticleEditorManager";

const useDynamicManager = (type) => {
  const productItemManager = useProductItemManager();
  const productGroupManager = useProductGroupManager();
  const pageEditorManager = usePageEditorManager();
  const uploadLogManager = useUploadLogManager();
  const productCategoryManager = useProductCategoryManager();
  const productBrandManager = useProductBrandManager();
  const staticPageManager = useStaticPageEditorManager();
  const articleEditorManager = useArticleEditorManager();

  switch (type) {
    case "productItem":
      return productItemManager;
    case "productGroup":
      return productGroupManager;
    case "pageEditor":
      return pageEditorManager;
    case "uploadLog":
      return uploadLogManager;
    case "productCategory":
      return productCategoryManager;
    case "productBrand":
      return productBrandManager;
    case "staticPageData":
      return staticPageManager;
    case "articleEditor":
      return articleEditorManager;
    default:
      throw new Error(`Unknown manager type: ${type}`);
  }
};

export default useDynamicManager;
