// redux/common/gallerySliceFactory.js
import { createSlice } from "@reduxjs/toolkit";
import { reorder } from "../../utils/reorder";
export const galleryInitialState = {
  featuredImage: [],
  galleryImages: [],
  sliderImages: [],
  selectedImage: {},
};
export const getGalleryReducers = ({
  galleryStateKey = "galleryImages",
  featuredImageStateKey = "featuredImage",
  sliderStateKey = "sliderImages",
  imageStateKey = "selectedImage",
} = {}) => ({
  // image
  setSelectedImage: (state, action) => {
    state[imageStateKey] = action.payload.selectedImage;
  },
  resetImageState: (state) => {
    state[imageStateKey] = {};
  },
  // featured image
  setFeaturedImage: (state, action) => {
    const img = action.payload.image;
    state[featuredImageStateKey] = Array.isArray(img) ? img : [img];
  },
  resetFeaturedImageState: (state) => {
    state[featuredImageStateKey] = [];
  },
  // gallery
  setSelectedGalleryImages: (state, action) => {
    const { selectedImages } = action.payload;

    state[galleryStateKey] = [...state[galleryStateKey], ...selectedImages];
    // const { selectedImages } = action.payload;
    // const currentImages = state[galleryStateKey];

    // // Assuming images have unique `id`s
    // const newImages = selectedImages.filter(
    //   (img) => !currentImages.some((existing) => existing._id === img._id)
    // );

    // state[galleryStateKey] = [...currentImages, ...newImages];
    // // const { selectedImages } = action.payload;
    // // state[galleryStateKey] = [...state[galleryStateKey], ...selectedImages];
  },
  removeImageFromGallery: (state, action) => {
    const { id, index } = action.payload;
    state[galleryStateKey] = state[galleryStateKey].filter(
      (g, i) => g._id !== id || i !== index
    );
  },
  updateGalleryImage: (state, action) => {
    state[galleryStateKey].map((g) => {
      if (g.image._id === action.payload.id) {
        g.image = action.payload.image;
        g.options = action.payload.options;
      }
    });
  },
  updateGalleryImageOrder: (state, action) => {
    const { start, end } = action.payload;
    state[galleryStateKey] = reorder(state[galleryStateKey], start, end);
    state[galleryStateKey].map((d, i) => {
      d.parentId = i;
    });
  },
  resetGalleryState: (state) => {
    state[galleryStateKey] = [];
  },
  // slider
  setSelectedSliderImages: (state, action) => {
    const { selectedImages } = action.payload;

    state[sliderStateKey] = [...state[sliderStateKey], ...selectedImages];
  },
  updateSliderImage: (state, action) => {
    state[sliderStateKey].map((g) => {
      if (g.image._id === action.payload.id) {
        g.image = action.payload.image;
        g.options = action.payload.options;
      }
    });
  },
  cloneGalleryImage: (state, action) => {
    const { selected } = action.payload;
    const cloneElement = { ...state[galleryStateKey][selected] };

    // Clone the array and insert the cloned element at the end
    state[galleryStateKey] = [...state[galleryStateKey], cloneElement];
  },
  removeSingleSliderImage: (state, action) => {
    const { id, index } = action.payload;
    state[sliderStateKey] = state[sliderStateKey].filter(
      (g, i) => g.image._id !== id || i !== index
    );
  },
  updateSliderImageOrder: (state, action) => {
    const { start, end } = action.payload;
    state[sliderStateKey] = reorder(state[sliderStateKey], start, end);
    state[sliderStateKey].map((d, i) => {
      d.parentId = i;
    });
  },
  cloneSliderImage: (state, action) => {
    const { selected } = action.payload;
    const cloneElement = { ...state[sliderStateKey][selected] };
    state[sliderStateKey] = [...state[sliderStateKey], cloneElement];
  },
  resetSliderState: (state) => {
    state[sliderStateKey] = [];
  },
});
