import { reorder } from "@/utils/reorder";

export const elementInitialState = { elementData: [], current: [] };

export const getElementReducers = ({ stateKey = "containerData" } = {}) => ({
  selectedElement: (state, action) => {
    state.current.content = [action.payload.content];
  },
  setSelectCurrentElement: (state, action) => {
    state.current = action.payload.clickedBox;
  },
  setEditedElement: (state, action) => {
    state.current = action.payload.editContent;
  },
  addcurrentElementToColumn: (state, action) => {
    const box = state[stateKey][state.current.parentId];
    if (box) {
      const column = box.content[state.current.innerId];
      if (column) {
        if (column.content.length === 0) {
          column.content.push(state.current);
        } else {
          const element = column.content[state.current.innerElementIndex];
          if (element) {
            state[stateKey][state.current.parentId].content[
              state.current.innerId
            ].content[state.current.innerElementIndex] = state.current;
          } else {
            state[stateKey][state.current.parentId].content[
              state.current.innerId
            ].content.push(state.current);
          }
        }
      }
    }
  },
  cloneElement: (state, action) => {
    const { parentId, innerId, innerElementIndex } = action.payload;
    const parent = state[stateKey][parentId];
    if (parent && parent.content[innerId]) {
      const innerContent = parent.content[innerId];
      const cloneElement = innerContent.content[innerElementIndex];
      if (cloneElement) {
        const newArray = [...innerContent.content, cloneElement];
        const updatedArray = newArray.map((c, i) => ({
          ...c,
          innerElementIndex: i,
        }));
        innerContent.content = updatedArray;
      }
    }
  },
  updateColumnElementOrder: (state, action) => {
    const { parentId, innerId, start, end } = action.payload;
    const updated = reorder(
      state[stateKey][parentId].content[innerId].content,
      start,
      end
    );
    state[stateKey][parentId].content[innerId].content = updated;
    updated.forEach((c, i) => (c.innerElementIndex = i));
  },
  moveElementAcrossContainers: (state, action) => {
    const {
      fromParentId,
      fromColumnId,
      fromElementIndex,
      toParentId,
      toColumnId,
      toIndex,
    } = action.payload;

    const fromContainer = state[stateKey][fromParentId];
    const toContainer = state[stateKey][toParentId];
    if (!fromContainer || !toContainer) return;

    const fromColIdx = fromContainer.content.findIndex(
      (c) => c.id === fromColumnId
    );
    const toColIdx = toContainer.content.findIndex((c) => c.id === toColumnId);
    if (fromColIdx < 0 || toColIdx < 0) return;

    const fromCol = fromContainer.content[fromColIdx];
    const toCol = toContainer.content[toColIdx];

    const [el] = fromCol.content.splice(fromElementIndex, 1);
    el.parentId = toParentId;
    el.innerId = toColumnId;
    toCol.content.splice(toIndex, 0, el);

    // normalize innerElementIndex
    fromCol.content.forEach((e, i) => (e.innerElementIndex = i));
    toCol.content.forEach((e, i) => (e.innerElementIndex = i));
  },
  moveColumnElement: (state, action) => {
    const { parentId, innerId, innerElementIndex, newColumnIndex } =
      action.payload;
    const fromColumn = state[stateKey][parentId]?.content[innerId];
    const toColumn = state[stateKey][parentId]?.content[newColumnIndex];
    if (fromColumn && toColumn) {
      const element = fromColumn.content.splice(innerElementIndex, 1)[0];
      toColumn.content.push(element);
      fromColumn.content.forEach((c, i) => (c.innerElementIndex = i));
      toColumn.content.forEach((c, i) => (c.innerElementIndex = i));
    }
  },
  removeElement: (state, action) => {
    const { parentId, innerId, innerElementIndex } = action.payload;
    console.log("payload", action.payload, stateKey);
    const column = state[stateKey][parentId]?.content?.[innerId];
    if (column) {
      column.content.splice(innerElementIndex, 1);
      column.content.forEach((el, i) => (el.innerElementIndex = i));
    }
  },
  resetElementState: (state, action) => {
    state.current = [];
  },
});
