import { createSlice } from "@reduxjs/toolkit";

export const commonPropsInitialState = {
  isPublished: true,
  isActive: false,
  isStatic: false,
  hasParent: false,
  showInMenu: true,
};

export const getCommonPropsReducers = ({
  name,
  isPublishedStateKey = "isPublished",
  isActiveStateKey = "isActive",
  isStaticStateKey = "isStatic",
  hasParentStateKey = "hasParent",
  showInMenuStateKey = "showInMenu",
  initialState = {},
} = {}) => ({
  publishedPage: (state, action) => {
    state[isPublishedStateKey] = action.payload.isPublished;
  },
  activeLayout: (state, action) => {
    state[isActiveStateKey] = action.payload.isActive;
  },
  staticPage: (state, action) => {
    state[isStaticStateKey] = action.payload.isStatic;
  },
  hasParent: (state, action) => {
    state[hasParentStateKey] = action.payload.hasParent;
  },
  showInMenu: (state, action) => {
    state[showInMenuStateKey] = action.payload.showInMenu;
  },
  resetCommonPropsState: (state) => {
    state[isPublishedStateKey] = true;
    state[isActiveStateKey] = false;
    state[isStaticStateKey] = false;
    state[hasParentStateKey] = false;
    state[showInMenuStateKey] = true;
  },
});
