import { createSlice } from "@reduxjs/toolkit";
import { reorder } from "../../utils/reorder";

export const columnInitialState = {
  selectedContainer: null,
};

export const getColumnReducers = ({ stateKey = "containerData" } = {}) => ({
  addColumn: (state, action) => {
    const { parentId, sizes, options } = action.payload;

    state[stateKey][parentId].size =
      state[stateKey][parentId].size.concat(sizes);
    for (let i = 0; i < sizes.length; i++) {
      state[stateKey][parentId].content.push({
        parentId,
        innerId: state[stateKey][parentId].content?.length + 1,
        content: [],
        options,
      });
    }
    state[stateKey][parentId].content?.forEach((c, i) => (c.innerId = i));
  },
  setSelectedColumn: (state, action) => {
    const { parentId, innerId, options } = action.payload;
    const container = state[stateKey][parentId]?.content[innerId];
    if (container) container.options = options;
  },
  updateColumnOrder: (state, action) => {
    const { parentId, start, end } = action.payload;
    state[stateKey][parentId].content = reorder(
      state[stateKey][parentId].content,
      start,
      end
    );
    state[stateKey][parentId].content.map((c, i) => {
      c.innerId = i;
    });
    state[stateKey][parentId].size = reorder(
      state[stateKey][parentId].size,
      start,
      end
    );
  },
  moveColumnAcrossContainers: (state, action) => {
    const { fromParentId, toParentId, fromIndex, toIndex } = action.payload;
    const fromList = state[stateKey][fromParentId]?.content;
    const toList = state[stateKey][toParentId]?.content;
    if (!fromList || !toList) return;

    const [moved] = fromList.splice(fromIndex, 1);
    moved.parentId = toParentId; // re-parent
    toList.splice(toIndex, 0, moved);

    // reindex if you keep positional helpers
  },
  updateColumnOptions: (state, action) => {
    const { parentId, innerId, options } = action.payload;

    // Ensure the parent container exists
    const container = state[stateKey][parentId];
    if (!container) return;

    // Initialize content array if needed
    if (!Array.isArray(container.content)) {
      container.content = [];
    }

    // Initialize the content item at innerId if needed
    if (!container.content[innerId]) {
      container.content[innerId] = {
        parentId,
        innerId,
        content: [],
        options: {},
      };
    }

    // ✅ Finally update options
    container.content[innerId].options = options;
    // const { parentId, innerId, options } = action.payload;
    // state[stateKey][parentId].content[innerId].options = options;
  },
  changeColumnSize: (state, action) => {
    const { parentId, innerId, size } = action.payload;
    const container = state[stateKey]?.[parentId];

    if (container && Array.isArray(container.size)) {
      container.size[innerId] = size;
    }
  },
  cloneColumn: (state, action) => {
    const { parentId, innerId, sizes, options } = action.payload;
    const parent = state[stateKey][parentId];
    if (parent && parent.content[innerId]) {
      state[stateKey][parentId].size =
        state[stateKey][parentId].size.concat(sizes);
      const cloneElement = parent.content[innerId];
      if (cloneElement) {
        const newArray = [...parent.content, cloneElement];
        const updatedArray = newArray.map((c, i) => ({ ...c, innerId: i }));
        parent.content = updatedArray;
      }
    }
  },
  removeColumn: (state, action) => {
    const { parentId, innerId } = action.payload;
    state[stateKey][parentId].content.splice(innerId, 1);
    state[stateKey][parentId].size.splice(innerId, 1);
    state[stateKey][parentId].content?.forEach((c, i) => (c.innerId = i));
  },
});
