// scripts/generate-icon-list.js
const fs = require("fs-extra");
const path = require("path");

const libraries = {
  fa: "react-icons/fa",
  md: "react-icons/md",
  hi: "react-icons/hi",
  bs: "react-icons/bs",
  ai: "react-icons/ai",
};

const iconList = [];

Object.entries(libraries).forEach(([libKey, libPath]) => {
  try {
    const icons = require(libPath);
    Object.keys(icons).forEach((iconName) => {
      iconList.push({ lib: libKey, name: iconName });
    });
  } catch (err) {
    console.error(`Failed to load ${libPath}:`, err);
  }
});

const outPath = path.join(__dirname, "../public/icon-list.json");
fs.writeFileSync(outPath, JSON.stringify(iconList, null, 2));
