"use client";

import { useEffect, useState, useRef } from "react";

export default function useSingleTabPerDocument(docId) {
  const [isDuplicate, setIsDuplicate] = useState(false);
  const channelRef = useRef(null);

  useEffect(() => {
    if (!docId) return;

    const channel = new BroadcastChannel(`doc:${docId}`);
    channelRef.current = channel;

    let hasOtherTab = false;

    const handleMessage = (event) => {
      if (event.data?.type === "PING") {
        // another tab is asking if someone is open
        channel.postMessage({ type: "PONG" });
      } else if (event.data?.type === "PONG") {
        // got a reply ⇒ at least one other tab
        hasOtherTab = true;
        setIsDuplicate(true);
      }
    };

    channel.onmessage = handleMessage;

    // announce ourselves & ask if someone else is already open
    channel.postMessage({ type: "PING" });

    return () => {
      channel.close();
    };
  }, [docId]);

  return { isDuplicate };
}
