import { useMemo } from "react";
import DOMPurify from "dompurify";

const useSafeHTML = (content, maxLength = 150) => {
  const sanitizedContent = useMemo(() => {
    // Trim the content to the specified length and add ellipsis if necessary
    const trimmedContent =
      content?.length > maxLength
        ? `${content.substring(0, maxLength)}...`
        : content;

    // Sanitize the trimmed content
    return {
      __html: DOMPurify.sanitize(trimmedContent),
    };
  }, [content, maxLength]);

  return sanitizedContent;
};

export default useSafeHTML;
