import { useState } from "react";

export const useModalManager = () => {
  const [modals, setModals] = useState({});

  const toggleModal = (modalName) => {
    setModals((prev) => {
      const updatedModals = {
        ...prev,
        [modalName]: !prev[modalName], // Toggle modal state dynamically
      };

      return updatedModals;
    });
  };
  const isModalOpen = (modalName) => !!modals[modalName]; // Check modal state safely

  return { modals, toggleModal, isModalOpen };
};
