import { useCallback, useEffect, useRef, useState } from "react";
import { useSelector } from "react-redux";
import useDynamicManager from "@/store/managers/useDynamicManager";
import { findLastIndexOfChar } from "@/utils/findLastIndexOfChar";

export const useEditorSlider = ({ toggleModal, modalName, type }) => {
  const {
    state,
    resetSliderState,
    resetElementState,
    selectedSliderImages,
    setSelectedSliderImages,
    removeSingleSliderImage,
    cloneSliderImage,
    updateSliderImage,
    updateSliderImageOrder,
    setSelectedElement,
    selectedElement,
    addcurrentElementToColumn,
  } = useDynamicManager(type);

  const [images, setImages] = useState(null);
  const [selectImageModal, setSelectImageModal] = useState(false);
  const [editImageModal, setEditImageModal] = useState(false);
  const [editedImage, setEditedImage] = useState({});
  // Refs
  const inputRefs = useRef([]);
  // If needed, to store references for editing
  const editImageRefs = useRef([]);

  // Clean up and re-select images if needed
  useEffect(() => {
    if (state.current.content?.length > 0) {
      setSelectedSliderImages({
        selectedImages: state.current.content?.[0]?.content?.[0]?.images,
      });
    }
  }, []);

  const handleEditSingleImage = useCallback((image) => {
    setEditedImage(image);
    setEditImageModal(true);
  }, []);

  const handleRemoveSingleImage = useCallback((image, idx) => {
    removeSingleSliderImage({
      id: image.image._id,
      index: idx,
    });
  }, []);

  const handleCloneSliderImage = useCallback((i) => {
    cloneSliderImage({ selected: i });
  }, []);

  const handleUpdateSliderImageOrder = useCallback((start, end) => {
    updateSliderImageOrder({ start, end });
  }, []);

  const handleSliderSubmit = useCallback(() => {
    const content = {
      type: "hero-slider",
      title: "hero-Slider",
      images: state.sliderImages,
    };

    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      if (ref) {
        if (ref.props) {
          // Handle cases where props contain value data
          if (Array.isArray(ref.props.value)) {
            // Handle arrays of values
            content[key] = ref.props.value.map((item) => item.value);
          } else {
            // Handle single values
            content[key] = ref.props.value?.value ?? "";
          }
        } else {
          // Handle cases where ref itself holds value data
          content[key] = ref?.value ?? "";
        }
      }
    });

    selectedElement({
      content: content,
    });

    addcurrentElementToColumn();
    resetSliderState();
    resetElementState();
    toggleModal(modalName);
    toggleModal("showSelectElementModal");
  }, [toggleModal, modalName]);

  const handleUpdateSliderImage = useCallback((image, options) => {
    updateSliderImage({
      id: image._id,
      image: image,
      options: options,
    });
  }, []);

  const handleSliderImageUpdate = useCallback(
    (contentData, img) => {
      const content = contentData;
      // Iterate through the keys of the ref object
      Object.entries(editImageRefs.current).forEach(([key, ref]) => {
        if (ref) {
          if (ref.props) {
            // Handle cases where props contain value data
            if (Array.isArray(ref.props.value)) {
              // Handle arrays of values
              content[key] = ref.props.value.map((item) => item.value);
            } else {
              // Handle single values
              content[key] = ref.props.value?.value ?? "";
            }
          } else {
            // Handle cases where ref itself holds value data
            content[key] = ref?.value ?? "";
          }
        }
      });

      updateSliderImage({
        id: img.image._id,
        image: img.image,
        options: content,
      });

      // Reset state and close modal
      setEditedImage({});
      setEditImageModal(false);
    },
    [editedImage]
  );

  return {
    images,
    selectImageModal,
    editImageModal,
    editedImage,

    // Setters
    setSelectImageModal,
    setEditImageModal,
    setEditedImage,

    // Handlers
    // handleSetSelectedSliderImages,
    handleEditSingleImage,
    handleRemoveSingleImage,
    handleCloneSliderImage,
    handleUpdateSliderImage,
    handleUpdateSliderImageOrder,
    handleSliderSubmit,
    handleSliderImageUpdate,
    findLastIndexOfChar,

    // Refs
    inputRefs,
    editImageRefs,
  };
};
