import { useCallback, useEffect } from "react";
import useDynamicManager from "@/store/managers/useDynamicManager";

export const useEditorSeparator = ({ toggleModal, modalName, type }) => {
  const {
    state,
    selectedElement,
    setSelectedImage,
    addcurrentElementToColumn,
    resetImageState,
  } = useDynamicManager(type);

  const handleImageRemove = () => {
    resetImageState();
  };

  // Clean up and re-select images if needed
  useEffect(() => {
    resetImageState();

    if (state.current.content?.length > 0) {
      setSelectedImage({
        selectedImage: state.current.content?.[0]?.content?.[0]?.selectedImage,
      });
    }
  }, []);

  const handleSubmitEditorSeparator = useCallback(
    (contendData, inputRefs) => {
      const content = contendData;
      Object.entries(inputRefs.current).forEach(([key, ref]) => {
        if (ref) {
          if (ref.props) {
            // Handle cases where props contain value data
            if (Array.isArray(ref.props.value)) {
              // Handle arrays of values
              content[key] = ref.props.value.map((item) => item.value);
            } else {
              // Handle single values
              content[key] = ref.props.value?.value ?? "";
            }
          } else {
            // Handle cases where ref itself holds value data
            content[key] = ref?.value ?? "";
          }
        }
      });
      selectedElement({
        content: content,
      });

      addcurrentElementToColumn();
      toggleModal(modalName);
      toggleModal("showSelectElementModal");
    },
    [toggleModal, modalName]
  );

  return {
    //helpers
    handleImageRemove,
    handleSubmitEditorSeparator,
  };
};
