import { useCallback } from "react";
import useDynamicManager from "@/store/managers/useDynamicManager";

export const useEditorProduct = ({ toggleModal, modalName, type }) => {
  const { selectedElement, addcurrentElementToColumn } =
    useDynamicManager(type);

  const handleSubmitBlogData = useCallback((contentData, inputRefs) => {
    const content = contentData;
    Object.entries(inputRefs.current).forEach(([key, ref]) => {
      if (ref) {
        if (ref.props) {
          // Handle cases where props contain value data
          if (Array.isArray(ref.props.value)) {
            // Handle arrays of values
            content[key] = ref.props.value.map((item) => item.value);
          } else {
            // Handle single values
            content[key] = ref.props.value?.value ?? "";
          }
        } else {
          // Handle cases where ref itself holds value data
          content[key] = ref?.value ?? "";
        }
      }
    });

    selectedElement({
      content: content,
    });

    addcurrentElementToColumn();
    toggleModal(modalName);
    toggleModal("showSelectElementModal");
  }, []);

  return {
    //helpers
    handleSubmitBlogData,
  };
};
