import { useCallback, useEffect, useRef, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import ApiCall from "@/api/api-calls";
import {
  resetImageState,
  selectedElement,
  addcurrentElementToColumn,
  setSelectedImage,
} from "@/store/slices/pageEditorSlice";
import { findLastIndexOfChar } from "@/utils/findLastIndexOfChar";

export const useEditorContentBox = ({ toggleModal, modalName }) => {
  const dispatch = useDispatch();

  const editableContent = useSelector(
    (state) => state.pageEditor.current.content
  );
  const selectedBoxImage = useSelector((state) => state.pageEditor.image);

  const handleSelectedElement = useCallback((content) => {
    selectedElement({
      content: content,
    });
  }, []);
  const handleUpdateContainerContent = useCallback(() => {
    addcurrentElementToColumn();
  }, []);

  const handleImageRemove = () => {
    resetImageState();
  };

  useEffect(() => {
    resetImageState();
    if (editableContent && editableContent.length > 0) {
      setSelectedImage({
        setSelectedImage: editableContent[0]?.content?.[0]?.image,
      });
    }
  }, [editableContent]);

  const handleSubmitContentBox = useCallback(
    (contentData, inputRefs) => {
      const content = contentData;
      Object.entries(inputRefs.current).forEach(([key, ref]) => {
        if (ref) {
          if (ref.props) {
            // Handle cases where props contain value data
            if (Array.isArray(ref.props.value)) {
              // Handle arrays of values
              content[key] = ref.props.value.map((item) => item.value);
            } else {
              // Handle single values
              content[key] = ref.props.value?.value ?? "";
            }
          } else {
            // Handle cases where ref itself holds value data
            content[key] = ref?.value ?? "";
          }
        }
      });
      handleSelectedElement(content);
      handleUpdateContainerContent();
      toggleModal(modalName);
      toggleModal("showSelectElementModal");
    },
    [
      handleSelectedElement,
      handleUpdateContainerContent,
      modalName,
      toggleModal,
    ]
  );

  return {
    //state
    editableContent,
    selectedBoxImage,
    //helpers
    handleSubmitContentBox,
    handleImageRemove,
  };
};
