import { addContainer, removeContainer } from "@/store/slices/pageEditorSlice";
import { initialData } from "@/data/data";

export const useContainerManager = (editorBoxList, toggleModal, dispatch) => {
  const addContainerBox = (data) => {
    const containerBoxes = data.columnSize.map((_, i) => ({
      parentId: editorBoxList.length ?? 0,
      innerId: i,
      content: [],
    }));
    dispatch(
      addContainer({
        container: {
          id: data._id,
          size: data.columnSize,
          content: containerBoxes,
          options: initialData.editor.container.defaults,
        },
      })
    );
    toggleModal("containerModal");
  };

  const removeContainerBox = (index) => {
    dispatch(removeContainer({ parentId: index }));
  };

  return { addContainerBox, removeContainerBox };
};
