import { useEffect, useState } from "react";

const useColumnSize = (data) => {
  const [column, setColumn] = useState(null);
  const [colSize, setColSize] = useState(null);

  useEffect(() => {
    const colX = data.x;
    const colY = data.y;

    setColSize(`${colX}/${colY}`);
    setColumn(((colX / colY) * 100).toFixed(0));
  }, [data]);

  return { column, colSize, setColSize, setColumn };
};

export default useColumnSize;
