import { useState, useEffect } from "react";
import ApiCall from "@/api/api-calls";

const useFetchTableData = (endpoint, initialQueryParams) => {
  const [data, setData] = useState([]);
  const [totalRecords, setTotalRecords] = useState(0);
  const [loading, setLoading] = useState(false);
  const [queryParams, setQueryParams] = useState(initialQueryParams);
  const fetchData = async () => {
    setLoading(true);
    try {
      const query = new URLSearchParams(queryParams).toString();
      const response = await ApiCall[endpoint].getAll(`?${query}`);
      setData(response.tableData);
      setTotalRecords(response.totalRecords);
    } catch (error) {
      console.error("Error fetching data:", error);
    } finally {
      setLoading(false);
    }
  };

  useEffect(() => {
    fetchData();
  }, [queryParams]);

  const updateQueryParams = (updates) =>
    setQueryParams((prev) => ({ ...prev, ...updates }));

  return {
    data,
    totalRecords,
    loading,
    queryParams,
    updateQueryParams,
  };
};

export default useFetchTableData;
