import { useEffect, useState, useRef } from "react";

export const useIntersectionObserver = () => {
  const [targetRef, setTargetRef] = useState(null);
  const [isIntersecting, setIsIntersecting] = useState(false);

  const observerRef = useRef(
    typeof IntersectionObserver !== "undefined" &&
      new IntersectionObserver(
        ([entry]) => {
          setIsIntersecting(entry.isIntersecting);
        },
        { rootMargin: "0px", threshold: 1.0 }
      )
  );

  useEffect(() => {
    const observer = observerRef.current;

    if (targetRef) {
      observer.observe(targetRef);
    }

    return () => {
      if (targetRef) {
        observer.unobserve(targetRef);
      }
    };
  }, [targetRef]);

  const resetObserver = () => {
    setIsIntersecting(false);
  };

  return [setTargetRef, isIntersecting, resetObserver];
};

export const useFiltereIntersectionObserver = () => {
  const [targetRef, setTargetRef] = useState(null);
  const [isFilteredIntersecting, setIsFilteredIntersecting] = useState(false);

  const observerRef = useRef(
    typeof IntersectionObserver !== "undefined" &&
      new IntersectionObserver(
        ([entry]) => {
          setIsFilteredIntersecting(entry.isIntersecting);
        },
        { rootMargin: "0px", threshold: 1.0 }
      )
  );

  useEffect(() => {
    const observer = observerRef.current;

    if (targetRef) {
      observer.observe(targetRef);
    }

    return () => {
      if (targetRef) {
        observer.unobserve(targetRef);
      }
    };
  }, [targetRef]);

  const resetObserverFiltered = () => {
    setIsFilteredIntersecting(false);
  };

  return [setTargetRef, isFilteredIntersecting, resetObserverFiltered];
};
