import React from "react";
import EditorBlog from "@/components/editor-elements/EditorBlog/EditorBlog";
import EditorButton from "@/components/editor-elements/EditorButton/EditorButton";
import EditorSingleArticle from "@/components/editor-elements/EditorSingleArticle/EditorSingleArticle";
import EditorProduct from "@/components/editor-elements/EditorProduct/EditorProduct";
import EditorSingleProduct from "@/components/editor-elements/EditorSingleProduct/EditorSingleProduct";
import EditorSlider from "@/components/editor-elements/EditorSlider/EditorSlider";
import EditorMainCategories from "@/components/editor-elements/EditorMainCategories/EditorMainCategories";
import EditorSingleForm from "@/components/editor-elements/EditorForm/EditorSingleForm";
import EditorContentBox from "@/components/editor-elements/EditorContentBox/EditorContentBox";
import EditorFlipBox from "@/components/editor-elements/EditorFlipBox/EditorFlipBox";
import EditorSeparator from "@/components/editor-elements/EditorSeparator/EditorSeparator";
import EditorLink from "@/components/editor-elements/EditorLink/EditorLink";
import EditorCode from "@/components/editor-elements/EditorCode/EditorCode";
import EditorTwitterEmbed from "@/components/editor-elements/EditorTwitterEmbed/EditorTwitterEmbed";
import EditorFacebookEmbed from "@/components/editor-elements/EditorFacebook/EditorFacebookEmbed";
import EditorYoutubeEmbed from "@/components/editor-elements/EditorYoutubeEmbed/EditorYoutubeEmbed";
import EditorMap from "@/components/editor-elements/EditorMap/EditorMap";
import EditorImage from "@/components/editor-elements/EditorImage/EditorImage";
import EditorGallery from "@/components/editor-elements/EditorGallery/EditorGallery";
import EditorTitle from "@/components/editor-elements/EditorTitle/EditorTitle";
import EditorText from "@/components/editor-elements/EditorText/EditorText";
import EditorPeople from "@/components/editor-elements/EditorPeople/EditorPeople";
import EditorArtForm from "@/components/editor-elements/EditorArtForm/EditorArtForm";
import EditorImageSlider from "@/components/editor-elements/EditorImageSlider/EditorImageSlider";
import EditorProductSlider from "@/components/editor-elements/EditorProductSlider/EditorProductSlider";
import EditorProductGallery from "@/components/editor-elements/EditorProductGallery/EditorGallery";
import useDynamicManager from "@/store/managers/useDynamicManager";
import ContainerSettings from "@/components/editor/container/containersettings/ContainerSettings";
import ColumnSettings from "@/components/editor/column/columnsettings/ColumnSettings";

const selectableElementsData = (
  editedContent,
  toggleModal,
  type,
  lifecycleHandlers = {},
  identifiers = {}
) => {
  const { parent = 0, index = 0, innerElementIndex = 0 } = identifiers;

  const makeUnique = (baseName) =>
    `${baseName}-${parent}-${index}-${innerElementIndex}`;

  const wrap = (component, baseModalName) =>
    React.cloneElement(component, {
      modalName: makeUnique(baseModalName),
      type,
      lifecycleHandlers,
      toggleModal,
    });

  return [
    {
      title: "Cikkek",
      modalName: makeUnique("blog"),
      sortOrder: 0,
      onClick: () => toggleModal(makeUnique("blog")),
      content: wrap(<EditorBlog data={editedContent} />),
      showInElements: false,
    },
    {
      title: "Egy cikk",
      modalName: makeUnique("single-article"),
      sortOrder: 1,
      onClick: () => toggleModal(makeUnique("single-article")),
      content: wrap(<EditorSingleArticle data={editedContent} />),
      showInElements: false,
    },
    {
      title: "Termékek",
      modalName: makeUnique("product"),
      sortOrder: 2,
      onClick: () => toggleModal(makeUnique("product")),
      type,
      content: wrap(<EditorProduct data={editedContent} />),
      showInElements: true,
    },
    {
      title: "Egy termék",
      modalName: makeUnique("single-product"),
      sortOrder: 3,
      onClick: () => toggleModal(makeUnique("single-product")),
      type,
      content: wrap(<EditorSingleProduct data={editedContent} />),
      showInElements: true,
    },
    {
      title: "Fő termék kategóriák",
      modalName: makeUnique("main-product-categories"),
      sortOrder: 4,
      onClick: () => toggleModal(makeUnique("main-product-categories")),
      content: wrap(<EditorMainCategories data={editedContent} />),
      showInElements: true,
    },
    {
      title: "Hero Slider",
      modalName: makeUnique("hero-slider"),
      sortOrder: 5,
      onClick: () => {
        toggleModal(makeUnique("hero-slider"));
      },
      type,
      content: wrap(<EditorSlider data={editedContent} />),
      showInElements: true,
    },
    {
      title: "Gomb",
      modalName: makeUnique("button"),
      sortOrder: 6,
      onClick: () => toggleModal(makeUnique("button")),
      type,
      content: wrap(<EditorButton data={editedContent} />),
      showInElements: true,
    },
    {
      title: "Elválasztó",
      modalName: makeUnique("separator"),
      sortOrder: 7,
      onClick: () => toggleModal(makeUnique("separator")),
      type,
      content: wrap(<EditorSeparator data={editedContent} />),
      showInElements: true,
    },
    {
      title: "Űrlap",
      modalName: makeUnique("single-form"),
      sortOrder: 8,
      onClick: () => toggleModal(makeUnique("single-form")),
      type,
      content: wrap(<EditorSingleForm data={editedContent} />),
      showInElements: false,
    },
    {
      title: "Content-box",
      modalName: makeUnique("content-box"),
      sortOrder: 9,
      onClick: () => toggleModal(makeUnique("content-box")),
      type,
      content: wrap(<EditorContentBox data={editedContent} />),
      showInElements: false,
    },
    {
      title: "Flip-box",
      modalName: makeUnique("flip-box"),
      sortOrder: 10,
      onClick: () => toggleModal(makeUnique("flip-box")),
      type,
      content: wrap(<EditorFlipBox data={editedContent} />),
      showInElements: false,
    },
    {
      title: "Link",
      modalName: makeUnique("link"),
      sortOrder: 11,
      onClick: () => toggleModal(makeUnique("link")),
      type,
      content: wrap(<EditorLink data={editedContent} />),
      showInElements: true,
    },
    {
      title: "Kód",
      modalName: makeUnique("code"),
      sortOrder: 12,
      onClick: () => toggleModal(makeUnique("code")),
      type,
      content: wrap(<EditorCode data={editedContent} />),
      showInElements: false,
    },
    {
      title: "Twitter beágyazókód",
      modalName: makeUnique("twitter-embed"),
      sortOrder: 13,
      onClick: () => toggleModal(makeUnique("twitter-embed")),
      type,
      content: wrap(<EditorTwitterEmbed data={editedContent} />),
      showInElements: false,
    },
    {
      title: "Facebook beágyazókód",
      modalName: makeUnique("facebook-embed"),
      sortOrder: 14,
      onClick: () => toggleModal(makeUnique("facebook-embed")),
      type,
      content: wrap(<EditorFacebookEmbed data={editedContent} />),
      showInElements: false,
    },
    {
      title: "Youtube beágyazókód",
      modalName: makeUnique("youtube-embed"),
      sortOrder: 15,
      onClick: () => toggleModal(makeUnique("youtube-embed")),
      type,
      content: wrap(<EditorYoutubeEmbed data={editedContent} />),
      showInElements: false,
    },
    {
      title: "Térkép",
      modalName: makeUnique("map"),
      sortOrder: 16,
      onClick: () => toggleModal(makeUnique("map")),
      type,
      content: wrap(<EditorMap data={editedContent} />),
      showInElements: true,
    },
    {
      title: "Kép",
      modalName: makeUnique("image"),
      sortOrder: 17,
      onClick: () => toggleModal(makeUnique("image")),
      type,
      content: wrap(<EditorImage data={editedContent} />),
      showInElements: true,
    },
    {
      title: "Galéria",
      modalName: makeUnique("gallery"),
      sortOrder: 18,
      onClick: () => toggleModal(makeUnique("gallery")),
      type,
      content: wrap(<EditorGallery data={editedContent} />),
      showInElements: true,
    },
    {
      title: "Cím",
      modalName: makeUnique("title"),
      sortOrder: 19,
      onClick: () => toggleModal(makeUnique("title")),
      content: wrap(<EditorTitle data={editedContent} />, "title"),
      showInElements: true,
    },
    {
      title: "Szöveg",
      modalName: makeUnique("text"),
      sortOrder: 20,
      onClick: () => toggleModal(makeUnique("text")),
      content: wrap(<EditorText data={editedContent} />, "text"),
      showInElements: true,
    },
    {
      title: "Kép slider",
      modalName: makeUnique("image-slider"),
      sortOrder: 21,
      onClick: () => toggleModal(makeUnique("image-slider")),
      type,
      content: wrap(<EditorImageSlider data={editedContent} />),
      showInElements: true,
    },
    {
      title: "Termék slider",
      modalName: makeUnique("product-slider"),
      sortOrder: 22,
      onClick: () => toggleModal(makeUnique("product-slider")),
      type,
      content: wrap(<EditorProductSlider data={editedContent} />),
      showInElements: true,
    },
    {
      title: "Konténer beállítások",
      modalName: makeUnique("container-options"),
      sortOrder: 23,
      onClick: () => toggleModal(makeUnique("container-options")),
      type,
      content: wrap(<ContainerSettings data={editedContent} />),
      showInElements: false,
    },
    {
      title: "Oszlop beállítások",
      modalName: makeUnique("column-options"),
      sortOrder: 24,
      onClick: () => toggleModal(makeUnique("column-options")),
      type,
      content: wrap(<ColumnSettings data={editedContent} />),
      showInElements: false,
    },
    {
      title: "Termék Galéria",
      modalName: makeUnique("product-gallery"),
      sortOrder: 25,
      onClick: () => toggleModal(makeUnique("product-gallery")),
      type,
      content: wrap(<EditorProductGallery data={editedContent} />),
      showInElements: false,
    },
    {
      title: "Személyek",
      modalName: makeUnique("people"),
      sortOrder: 21,
      onClick: () => toggleModal(makeUnique("people")),
      type,
      content: wrap(<EditorPeople data={editedContent} />),
      showInElements: false,
    },
    {
      title: "Művészeti ág",
      modalName: makeUnique("artform"),
      sortOrder: 22,
      onClick: () => toggleModal(makeUnique("artform")),
      type,
      content: wrap(<EditorArtForm data={editedContent} />),
      showInElements: false,
    },
  ];
};

export default selectableElementsData;
