export const initialData = {
  editor: {
    blog: {
      layoutTypes: [
        { id: 0, value: "large", label: "Nagy képpel" },
        {
          id: 1,
          value: "text-over-image",
          label: "Nagy képpel - szöveg a képen",
        },
        { id: 2, value: "base", label: "Alap" },
        { id: 3, value: "left", label: "Kép bal - szöveg jobb oldalon" },
        { id: 4, value: "right", label: "Kép jobb - szöveg bal oldalon" },
        { id: 5, value: "noimage", label: "Kép nélkül" },
      ],
      orderBy: [
        { id: 0, value: "date", label: "Dátum" },
        { id: 1, value: "post-title", label: "Bejegyzés címe" },
        // { id: 2, value: "author", label: "Szerző" },
      ],
      contentLength: [
        { id: 0, value: "excerpt", label: "Rövid szöveg" },
        { id: 1, value: "full", label: "Teljes szöveg" },
        { id: 2, value: "no-text", label: "Szöveg nélkül" },
      ],
      infiniteLoad: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      showDate: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      showReadMore: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      showTags: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      postsLength: [
        { id: 1, value: "1", label: "1" },
        { id: 2, value: "2", label: "2" },
        { id: 3, value: "3", label: "3" },
        { id: 4, value: "4", label: "4" },
        { id: 5, value: "5", label: "5" },
        { id: 6, value: "6", label: "6" },
        { id: 7, value: "7", label: "7" },
        { id: 8, value: "8", label: "8" },
        { id: 9, value: "9", label: "9" },
        { id: 10, value: "10", label: "10" },
        { id: 11, value: "11", label: "11" },
        { id: 12, value: "12", label: "12" },
        { id: 13, value: "13", label: "13" },
        { id: 14, value: "14", label: "14" },
        { id: 15, value: "15", label: "15" },
        { id: 16, value: "16", label: "16" },
        { id: 17, value: "17", label: "17" },
        { id: 18, value: "18", label: "17" },
        { id: 19, value: "19", label: "19" },
        { id: 20, value: "20", label: "20" },
        { id: 21, value: "21", label: "21" },
        { id: 22, value: "22", label: "22" },
        { id: 23, value: "23", label: "23" },
        { id: 24, value: "24", label: "24" },
        { id: 25, value: "25", label: "25" },
      ],
    },
    product: {
      layoutTypes: [
        { id: 0, value: "large", label: "Nagy képpel" },
        { id: 1, value: "base", label: "Alap" },
        // { id: 2, value: "left", label: "Kép bal - szöveg jobb oldalon" },
        // { id: 3, value: "right", label: "Kép jobb - szöveg bal oldalon" },
        // { id: 4, value: "noimage", label: "Kép nélkül" },
      ],
      orderBy: [
        { id: 0, value: "date", label: "Dátum" },
        { id: 1, value: "productTitle", label: "Termék neve" },
        // { id: 2, value: "author", label: "Szerző" },
      ],
      displayedProperties: [
        { id: 0, value: "productTitle", label: "Termék név" },
        { id: 1, value: "productSlug", label: "Termék url" },
        { id: 2, value: "productTitleLink", label: "Title link - SEO" },
        { id: 3, value: "productTags", label: "Termék címkék" },
        { id: 4, value: "productItemNumber", label: "Termék azonosító" },
        { id: 5, value: "productPackType", label: "Kiszerelés" },
        { id: 6, value: "productSize", label: "Termék mérete" },
        {
          id: 7,
          value: "productQtyPerPack",
          label: "Mennyiség - csomag",
        },
        {
          id: 8,
          value: "productQtyPerCarton",
          label: "Mennyiség - karton",
        },
        { id: 9, value: "productMaterial", label: "Termék anyaga" },
        {
          id: 12,
          value: "productPieceWebshopPrice",
          label: "Termék webshop ár - nettó",
        },
        { id: 13, value: "productDescription", label: "Termék leírás" },
        { id: 14, value: "productCategory", label: "Termék kategóriák" },
        { id: 15, value: "productFeaturedImage", label: "Termék kép" },
        { id: 16, value: "productContent", label: "Termék elemek" },
        { id: 17, value: "productDiscount", label: "Kedvezmény" },
        { id: 18, value: "productVat", label: "Áfa érték - %" },
        { id: 19, value: "minQty", label: "Minimum rendelhető" },
        { id: 20, value: "connectedProducts", label: "Kapcsolódó termékek" },
        { id: 21, value: "productCerts", label: "Tanúsítványok" },
        { id: 22, value: "createdAt", label: "Létrehozva" },
        { id: 23, value: "updatedAt", label: "Frissítve" },
        { id: 24, value: "isActive", label: "Aktív" },
        { id: 25, value: "isLatest", label: "Legújabb" },
        { id: 26, value: "isEmphasized", label: "Kiemelt" },
        { id: 27, value: "inStock", label: "Raktáron" },
      ],
      infiniteLoad: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      showDate: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      showReadMore: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      showTags: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      productLength: [
        { id: 1, value: "1", label: "1" },
        { id: 2, value: "2", label: "2" },
        { id: 3, value: "3", label: "3" },
        { id: 4, value: "4", label: "4" },
        { id: 5, value: "5", label: "5" },
        { id: 6, value: "6", label: "6" },
        { id: 7, value: "7", label: "7" },
        { id: 8, value: "8", label: "8" },
        { id: 9, value: "9", label: "9" },
        { id: 10, value: "10", label: "10" },
        { id: 11, value: "11", label: "11" },
        { id: 12, value: "12", label: "12" },
        { id: 13, value: "13", label: "13" },
        { id: 14, value: "14", label: "14" },
        { id: 15, value: "15", label: "15" },
        { id: 16, value: "16", label: "16" },
        { id: 17, value: "17", label: "17" },
        { id: 18, value: "18", label: "17" },
        { id: 19, value: "19", label: "19" },
        { id: 20, value: "20", label: "20" },
        { id: 21, value: "21", label: "21" },
        { id: 22, value: "22", label: "22" },
        { id: 23, value: "23", label: "23" },
        { id: 24, value: "24", label: "24" },
        { id: 25, value: "25", label: "25" },
      ],
    },
    mainProductCategories: {
      showImage: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      orderBy: [
        { id: 0, value: "date", label: "Dátum" },
        {
          id: 1,
          value: "productCategoryTitle",
          label: "Termék kategória neve",
        },
        { id: 1, value: "sorting", label: "Termék kategória sorrend" },
      ],
    },
    title: {
      titleTypes: [
        { id: 0, value: "h1", label: "H1" },
        { id: 1, value: "h2", label: "H2" },
        { id: 2, value: "h3", label: "H3" },
        { id: 3, value: "h4", label: "H4" },
        { id: 4, value: "h5", label: "H5" },
        { id: 5, value: "h6", label: "H6" },
      ],
      titleAlignment: [
        { id: 0, value: "left", label: "Balra zárt" },
        { id: 1, value: "center", label: "Középen" },
        { id: 2, value: "right", label: "Jobbra zárt" },
      ],
      titleOrder: [
        { id: 0, value: "row", label: "Sor" },
        { id: 1, value: "column", label: "Oszlop" },
      ],
      titlePosition: [
        { id: 0, value: "relative", label: "Relatív" },
        { id: 1, value: "absolute", label: "Abszolút" },
        { id: 2, value: "fixed", label: "Fix" },
      ],
      fontFamily: [
        {
          id: 0,
          value: "open-sans",
          label: "Open Sans, Helvetica, Arial, sans-serif",
        },
        {
          id: 1,
          value: "arial",
          label: "'Arial Black', Gadget, sans-serif",
        },
        {
          id: 2,
          value: "bookman",
          label: "'Bookman Old Style', serif",
        },
        {
          id: 3,
          value: "comic",
          label: "'Comic Sans MS', cursive",
        },
        { id: 4, value: "courier", label: "Courier, monospace" },
        { id: 5, value: "garamond", label: "Garamond, serif" },
        { id: 6, value: "georgia", label: "Georgia, serif" },
        {
          id: 7,
          value: "impact",
          label: "Impact, Charcoal, sans-serif",
        },
        {
          id: 8,
          value: "lucida",
          label: "'Lucida Console', Monaco, monospace",
        },
        {
          id: 9,
          value: "unicode",
          label: "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
        },
        {
          id: 10,
          value: "tahoma",
          label: "'Tahoma', Geneva, sans-serif",
        },
        {
          id: 11,
          value: "serif",
          label: "'MS Serif', 'New York', sans-serif",
        },
        {
          id: 12,
          value: "palatino",
          label: "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
        },
        {
          id: 13,
          value: "times",
          label: "'Times New Roman', Times,serif",
        },
        {
          id: 14,
          value: "trebuchet",
          label: "'Trebuchet MS', Helvetica, sans-serif",
        },
        {
          id: 15,
          value: "vardana",
          label: "Verdana, Geneva, sans-serif",
        },
        {
          id: 17,
          value: "'Roboto Flex', Geneva, sans-serif",
          label: "'Roboto Flex', Geneva, sans-serif",
        },
        { id: 18, label: "Lora", value: "Lora" },
        { id: 19, label: "DIN Pro", value: "DIN Pro" },
        {
          id: 20,
          value: "'Inter', sans-serif",
          label: "'Inter', sans-serif",
        },
        {
          id: 21,
          value: "'Playfair Display', serif",
          label: "'Playfair Display', serif",
        },
      ],
    },
    text: {
      textTypes: [
        { id: 0, value: "xs", label: "Kicsi" },
        { id: 1, value: "sm", label: "Kicsit nagyobb" },
        { id: 2, value: "base", label: "Normál" },
        { id: 3, value: "lg", label: "Nagyobb" },
        { id: 4, value: "xl", label: "Óriási" },
        { id: 5, value: "2xl", label: "Hatalmas" },
      ],
      textAlignment: [
        { id: 0, value: "left", label: "Balra zárt" },
        { id: 1, value: "center", label: "Középen" },
        { id: 2, value: "right", label: "Jobbra zárt" },
      ],
      textPosition: [
        { id: 0, value: "relative", label: "Relatív" },
        { id: 1, value: "absolute", label: "Abszolút" },
        { id: 2, value: "fixed", label: "Fix" },
      ],
      textOrder: [
        { id: 0, value: "row", label: "Sor" },
        { id: 1, value: "column", label: "Oszlop" },
      ],
      fontFamily: [
        {
          id: 0,
          value: "open-sans",
          label: "Open Sans, Helvetica, Arial, sans-serif",
        },
        {
          id: 1,
          value: "arial",
          label: "'Arial Black', Gadget, sans-serif",
        },
        {
          id: 2,
          value: "bookman",
          label: "'Bookman Old Style', serif",
        },
        {
          id: 3,
          value: "comic",
          label: "'Comic Sans MS', cursive",
        },
        { id: 4, value: "courier", label: "Courier, monospace" },
        { id: 5, value: "garamond", label: "Garamond, serif" },
        { id: 6, value: "georgia", label: "Georgia, serif" },
        {
          id: 7,
          value: "impact",
          label: "Impact, Charcoal, sans-serif",
        },
        {
          id: 8,
          value: "lucida",
          label: "'Lucida Console', Monaco, monospace",
        },
        {
          id: 9,
          value: "unicode",
          label: "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
        },
        {
          id: 10,
          value: "tahoma",
          label: "'Tahoma', Geneva, sans-serif",
        },
        {
          id: 11,
          value: "serif",
          label: "'MS Serif', 'New York', sans-serif",
        },
        {
          id: 12,
          value: "palatino",
          label: "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
        },
        {
          id: 13,
          value: "times",
          label: "'Times New Roman', Times,serif",
        },
        {
          id: 14,
          value: "trebuchet",
          label: "'Trebuchet MS', Helvetica, sans-serif",
        },
        {
          id: 15,
          value: "vardana",
          label: "Verdana, Geneva, sans-serif",
        },
        {
          id: 17,
          value: "'Roboto Flex', Geneva, sans-serif",
          label: "'Roboto Flex', Geneva, sans-serif",
        },
        { id: 18, label: "Lora", value: "Lora" },
        { id: 19, label: "DIN Pro", value: "DIN Pro" },
        {
          id: 20,
          value: "'Inter', sans-serif",
          label: "'Inter', sans-serif",
        },
        {
          id: 21,
          value: "'Playfair Display', serif",
          label: "'Playfair Display', serif",
        },
      ],
    },
    separator: {
      separatorDesign: [
        { id: 0, value: "dotted", label: "Dotted" },
        { id: 1, value: "dashed", label: "Dashed" },
        { id: 2, value: "solid", label: "Solid" },
        { id: 3, value: "double", label: "Double" },
        { id: 4, value: "groove", label: "Groove" },
        { id: 5, value: "ridge", label: "Ridge" },
        { id: 6, value: "inset", label: "Inset" },
        { id: 7, value: "outSet", label: "Outset" },
        { id: 8, value: "none", label: "None" },
        { id: 9, value: "hidden", label: "Hidden" },
      ],
      separatorPosition: [
        { id: 0, value: "left", label: "Bal" },
        { id: 1, value: "center", label: "Közép" },
        { id: 2, value: "right", label: "Jobb" },
      ],
    },
    image: {
      imageTypes: [
        { id: 0, value: "image", label: "Kép" },
        { id: 1, value: "background", label: "Háttér" },
      ],
      imageObjectFit: [
        { id: 0, value: "contain", label: "Contain" },
        { id: 1, value: "cover", label: "Cover" },
        { id: 2, value: "fill", label: "Fill" },
        { id: 3, value: "inherit", label: "Inherit" },
        { id: 4, value: "initial", label: "Initial" },
        { id: 5, value: "none", label: "None" },
        { id: 6, value: "revert", label: "Revert" },
        { id: 7, value: "scale-down", label: "Scale down" },
        { id: 8, value: "unset", label: "Unset" },
      ],
      imageObjectPosition: [
        { id: 0, value: "bottom", label: "Bottom" },
        { id: 1, value: "center", label: "Center" },
        { id: 2, value: "inherit", label: "Inherit" },
        { id: 3, value: "initial", label: "Initial" },
        { id: 4, value: "left", label: "Left" },
        { id: 5, value: "revert", label: "Revert" },
        { id: 6, value: "right", label: "Right" },
        { id: 7, value: "top", label: "Top" },
        { id: 8, value: "unset", label: "Unset" },
      ],
      imageCutToSize: [
        { id: 0, value: "1", label: "Igen" },
        { id: 1, value: "0", label: "Nem" },
      ],
      imageBackgroundPosition: [
        { id: 0, value: "inherit", label: "Inherit" },
        { id: 1, value: "fixed", label: "Fixed" },
        { id: 2, value: "local", label: "local" },
        { id: 3, value: "scroll", label: "scroll" },
        { id: 4, value: "unset", label: "unset" },
      ],
      imageBorderTypes: [
        { id: 0, value: "dotted", label: "Dotted" },
        { id: 1, value: "dashed", label: "Dashed" },
        { id: 2, value: "solid", label: "Solid" },
        { id: 3, value: "double", label: "Double" },
        { id: 4, value: "groove", label: "Groove" },
        { id: 5, value: "ridge", label: "Ridge" },
        { id: 6, value: "inset", label: "Inset" },
        { id: 7, value: "outSet", label: "Outset" },
        { id: 8, value: "none", label: "None" },
        { id: 9, value: "hidden", label: "Hidden" },
      ],
      animationTypes: [
        { id: 0, value: "noanimation", label: "Nincs animáció" },
        { id: 1, value: "zoomin", label: "Zoom in" },
        { id: 2, value: "zoomout", label: "Zoom out" },
        { id: 3, value: "liftup", label: "Lift up" },
      ],
      imageTargets: [
        { id: 0, value: "_self", label: "Ugyanott nyílik a link" },
        { id: 1, value: "_blank", label: "Másik oldalt nyit a link" },
      ],
      imageLayers: [
        { id: 0, value: "nolayer", label: "Nincs layer a képen" },
        { id: 1, value: "layer", label: "Van layer a képen" },
      ],
      layerValues: [
        { id: 0, value: "0", label: "0" },
        { id: 1, value: "0.1", label: "0.1" },
        { id: 2, value: "0.2", label: "0.2" },
        { id: 3, value: "0.3", label: "0.3" },
        { id: 4, value: "0.4", label: "0.4" },
        { id: 5, value: "0.5", label: "0.5" },
        { id: 6, value: "0.6", label: "0.6" },
        { id: 7, value: "0.7", label: "0.7" },
        { id: 8, value: "0.8", label: "0.8" },
        { id: 9, value: "0.9", label: "0.9" },
        { id: 10, value: "1", label: "1" },
      ],
    },
    gallery: {
      columnCount: [
        { id: 0, value: "1", label: "1" },
        { id: 1, value: "2", label: "2" },
        { id: 2, value: "3", label: "3" },
        { id: 3, value: "4", label: "4" },
        { id: 4, value: "5", label: "5" },
        { id: 5, value: "6", label: "6" },
      ],
    },
    button: {
      transformTypes: [
        { id: 0, value: "uppercase", label: "Nagybetűssé alakítás" },
        { id: 1, value: "normal", label: "Normál megjelenítés" },
      ],
      textAlignment: [
        { id: 0, value: "left", label: "Balra zárt" },
        { id: 1, value: "center", label: "Középre zárt" },
        { id: 2, value: "right", label: "Jobbra zárt" },
      ],
      buttonSizes: [
        { id: 0, value: "xs", label: "Kicsi" },
        { id: 1, value: "base", label: "Normál" },
        { id: 2, value: "lg", label: "Nagy" },
        { id: 3, value: "xl", label: "Óriási" },
      ],
      buttonSpan: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      buttonBorderTypes: [
        { id: 0, value: "dotted", label: "Dotted" },
        { id: 1, value: "dashed", label: "Dashed" },
        { id: 2, value: "solid", label: "Solid" },
        { id: 3, value: "double", label: "Double" },
        { id: 4, value: "groove", label: "Groove" },
        { id: 5, value: "ridge", label: "Ridge" },
        { id: 6, value: "inset", label: "Inset" },
        { id: 7, value: "outSet", label: "Outset" },
        { id: 8, value: "none", label: "None" },
        { id: 9, value: "hidden", label: "Hidden" },
      ],
    },
    link: {
      transformTypes: [
        { id: 0, value: "uppercase", label: "Nagybetűssé alakítás" },
        { id: 1, value: "normal", label: "Normál megjelenítés" },
      ],
      textAlignment: [
        { id: 0, value: "left", label: "Balra zárt" },
        { id: 1, value: "center", label: "Középre zárt" },
        { id: 2, value: "right", label: "Jobbra zárt" },
      ],
      linkSpan: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
    },
    slider: {
      textTypes: [
        { id: 0, value: "h1", label: "H1" },
        { id: 1, value: "h2", label: "H2" },
        { id: 2, value: "h3", label: "H3" },
        { id: 3, value: "h4", label: "H4" },
        { id: 4, value: "h5", label: "H5" },
        { id: 5, value: "h6", label: "H6" },
      ],
      textAlignment: [
        { id: 0, value: "left", label: "Balra zárt" },
        { id: 1, value: "center", label: "Középen" },
        { id: 2, value: "right", label: "Jobbra zárt" },
      ],

      alignment: [
        { id: 0, value: "left", label: "Balra zárt" },
        { id: 1, value: "center", label: "Középre zárt" },
        { id: 2, value: "right", label: "Jobbra zárt" },
      ],
      autoplay: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      slidesPerView: [
        { id: 1, value: "1", label: "1" },
        { id: 2, value: "2", label: "2" },
        { id: 3, value: "3", label: "3" },
        { id: 4, value: "4", label: "4" },
        { id: 5, value: "5", label: "5" },
        { id: 6, value: "6", label: "6" },
      ],
      spaceBetween: [
        { id: 0, value: "0", label: "0" },
        { id: 1, value: "10", label: "10" },
        { id: 2, value: "20", label: "20" },
        { id: 3, value: "30", label: "30" },
        { id: 4, value: "40", label: "40" },
        { id: 5, value: "50", label: "50" },
      ],
      mouseWheelControl: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      keyboardControl: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      pagination: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      zoom: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      navigation: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      smoothHeight: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      animationTypes: [
        { id: 0, value: "noanimation", label: "Nincs animáció" },
        { id: 1, value: "zoomin", label: "Zoom in" },
        { id: 2, value: "zoomout", label: "Zoom out" },
        { id: 3, value: "liftup", label: "Lift up" },
      ],
      contentOrder: [
        { id: 0, value: "row", label: "Sor" },
        { id: 1, value: "col", label: "Oszlop" },
      ],
      contentOrderBreakpoints: [
        { id: 0, value: "max-xxs:!flex-row", label: "XXS - Sor" },
        { id: 1, value: "max-xs:!flex-row", label: "XS - Sor" },
        { id: 2, value: "max-sm:!flex-row", label: "SM - Sor" },
        { id: 3, value: "max-md:!flex-row", label: "MD - Sor" },
        { id: 4, value: "max-lg:!flex-row", label: "LG - Sor" },
        { id: 5, value: "max-xl:!flex-row", label: "XL - Sor" },
        { id: 6, value: "max-2xl:!flex-row", label: "2XL - Sor" },
        { id: 7, value: "max-xxs:!flex-col", label: "XXS - Oszlop" },
        { id: 8, value: "max-xs:!flex-col", label: "XS - Oszlop" },
        { id: 9, value: "max-sm:!flex-col", label: "SM - Oszlop" },
        { id: 10, value: "max-md:!flex-col", label: "MD - Oszlop" },
        { id: 11, value: "max-lg:!flex-col", label: "LG - Oszlop" },
        { id: 12, value: "max-xl:!flex-col", label: "XL - Oszlop" },
        { id: 13, value: "max-2xl:!flex-col", label: "2XL - Oszlop" },
      ],
      contentJustify: [
        { id: 0, value: "center", label: "Center" },
        { id: 1, value: "end", label: "End" },
        { id: 2, value: "flex-end", label: "Flex-end" },
        { id: 3, value: "flex-start", label: "Flex-start" },
        { id: 4, value: "inherit", label: "Inherit" },
        { id: 5, value: "initial", label: "Initial" },
        { id: 6, value: "left", label: "Left" },
        { id: 7, value: "normal", label: "Normal" },
        { id: 8, value: "revert", label: "Revert" },
        { id: 9, value: "right", label: "Right" },
        { id: 10, value: "space-around", label: "Space-around" },
        { id: 11, value: "space-between", label: "Space-between" },
        { id: 12, value: "space-evenly", label: "Space-evenly" },
        { id: 13, value: "start", label: "Start" },
        { id: 14, value: "stretch", label: "Stretch" },
        { id: 15, value: "unset", label: "Unset" },
      ],
      contentAlign: [
        { id: 0, value: "baseline", label: "Baseline" },
        { id: 1, value: "center", label: "Center" },
        { id: 3, value: "end", label: "End" },
        { id: 4, value: "flex-end", label: "Flex-end" },
        { id: 5, value: "flex-start", label: "Flex-start" },
        { id: 6, value: "inherit", label: "Inherit" },
        { id: 7, value: "initial", label: "Initial" },
        { id: 8, value: "normal", label: "Normal" },
        { id: 9, value: "revert", label: "Revert" },
        { id: 10, value: "self-end", label: "Self-end" },
        { id: 11, value: "self-start", label: "Self-start" },
        { id: 12, value: "start", label: "Start" },
        { id: 13, value: "stretch", label: "Stretch" },
        { id: 14, value: "unset", label: "Unset" },
      ],
      fontFamily: [
        {
          id: 0,
          value: "open-sans",
          label: "Open Sans, Helvetica, Arial, sans-serif",
        },
        {
          id: 1,
          value: "arial",
          label: "'Arial Black', Gadget, sans-serif",
        },
        {
          id: 2,
          value: "bookman",
          label: "'Bookman Old Style', serif",
        },
        {
          id: 3,
          value: "comic",
          label: "'Comic Sans MS', cursive",
        },
        { id: 4, value: "courier", label: "Courier, monospace" },
        { id: 5, value: "garamond", label: "Garamond, serif" },
        { id: 6, value: "georgia", label: "Georgia, serif" },
        {
          id: 7,
          value: "impact",
          label: "Impact, Charcoal, sans-serif",
        },
        {
          id: 8,
          value: "lucida",
          label: "'Lucida Console', Monaco, monospace",
        },
        {
          id: 9,
          value: "unicode",
          label: "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
        },
        {
          id: 10,
          value: "tahoma",
          label: "'Tahoma', Geneva, sans-serif",
        },
        {
          id: 11,
          value: "serif",
          label: "'MS Serif', 'New York', sans-serif",
        },
        {
          id: 12,
          value: "palatino",
          label: "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
        },
        {
          id: 13,
          value: "times",
          label: "'Times New Roman', Times,serif",
        },
        {
          id: 14,
          value: "trebuchet",
          label: "'Trebuchet MS', Helvetica, sans-serif",
        },
        {
          id: 15,
          value: "vardana",
          label: "Verdana, Geneva, sans-serif",
        },
        {
          id: 17,
          value: "'Roboto Flex', Geneva, sans-serif",
          label: "'Roboto Flex', Geneva, sans-serif",
        },
        { id: 18, label: "Lora", value: "Lora" },
        { id: 19, label: "DIN Pro", value: "DIN Pro" },
        {
          id: 20,
          value: "'Inter', sans-serif",
          label: "'Inter', sans-serif",
        },
        {
          id: 21,
          value: "'Playfair Display', serif",
          label: "'Playfair Display', serif",
        },
      ],
      defaults: {
        type: "slider",
        margin: "0 0 0 0",
        alignment: "center",
        autoplay: "true",
        background: "rgba(255, 255, 255, 1)",
        smoothHeight: "true",
        animationTypes: "noanimation",
        imageSizeDimensions: {
          width: "100%",
          height: "100%",
        },
      },
    },
    map: {
      zoomLevel: [
        { id: 1, value: "1", label: "1" },
        { id: 2, value: "2", label: "2" },
        { id: 3, value: "3", label: "3" },
        { id: 4, value: "4", label: "4" },
        { id: 5, value: "5", label: "5" },
        { id: 6, value: "6", label: "6" },
        { id: 7, value: "7", label: "7" },
        { id: 8, value: "8", label: "8" },
        { id: 9, value: "9", label: "9" },
        { id: 10, value: "10", label: "10" },
        { id: 11, value: "11", label: "11" },
        { id: 12, value: "12", label: "12" },
        { id: 13, value: "13", label: "13" },
        { id: 14, value: "14", label: "14" },
        { id: 15, value: "15", label: "15" },
        { id: 16, value: "16", label: "16" },
        { id: 17, value: "17", label: "17" },
        { id: 18, value: "18", label: "17" },
        { id: 19, value: "19", label: "19" },
        { id: 20, value: "20", label: "20" },
      ],
      mouseZoom: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
    },
    container: {
      containerColDistance: [
        { id: 0, value: "0", label: "0" },
        { id: 1, value: "5", label: "5" },
        { id: 2, value: "10", label: "10" },
        { id: 3, value: "15", label: "15" },
        { id: 4, value: "20", label: "20" },
        { id: 5, value: "25", label: "25" },
        { id: 6, value: "30", label: "30" },
      ],
      borderDesign: [
        { id: 0, value: "dotted", label: "Dotted" },
        { id: 1, value: "dashed", label: "Dashed" },
        { id: 2, value: "solid", label: "Solid" },
        { id: 3, value: "double", label: "Double" },
        { id: 4, value: "groove", label: "Groove" },
        { id: 5, value: "ridge", label: "Ridge" },
        { id: 6, value: "inset", label: "Inset" },
        { id: 7, value: "outSet", label: "Outset" },
        { id: 8, value: "none", label: "None" },
        { id: 9, value: "hidden", label: "Hidden" },
      ],
      containerBoxShadow: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      contentOrder: [
        { id: 0, value: "row", label: "Sor" },
        { id: 1, value: "col", label: "Oszlop" },
      ],
      breakpoints: [
        { id: 0, value: "sm", label: "SM" },
        { id: 1, value: "md", label: "MD" },
        { id: 2, value: "lg", label: "LG" },
        { id: 3, value: "xl", label: "XL" },
        { id: 4, value: "2xl", label: "2XL" },
      ],
      autoShadow: [
        { id: 0, value: "shadow-sm", label: "SM" },
        { id: 1, value: "shadow-md", label: "MD" },
        { id: 2, value: "shadow-lg", label: "LG" },
        { id: 3, value: "shadow-xl", label: "XL" },
        { id: 4, value: "shadow-2xl", label: "2XL" },
        { id: 5, value: "none", label: "None" },
      ],
      contentOrderBreakpoints: [
        { id: 0, value: "max-xxs:!flex-row", label: "XXS - Sor" },
        { id: 1, value: "max-xs:!flex-row", label: "XS - Sor" },
        { id: 2, value: "max-sm:!flex-row", label: "SM - Sor" },
        { id: 3, value: "max-md:!flex-row", label: "MD - Sor" },
        { id: 4, value: "max-lg:!flex-row", label: "LG - Sor" },
        { id: 5, value: "max-xl:!flex-row", label: "XL - Sor" },
        { id: 6, value: "max-2xl:!flex-row", label: "2XL - Sor" },
        { id: 7, value: "max-xxs:!flex-col", label: "XXS - Oszlop" },
        { id: 8, value: "max-xs:!flex-col", label: "XS - Oszlop" },
        { id: 9, value: "max-sm:!flex-col", label: "SM - Oszlop" },
        { id: 10, value: "max-md:!flex-col", label: "MD - Oszlop" },
        { id: 11, value: "max-lg:!flex-col", label: "LG - Oszlop" },
        { id: 12, value: "max-xl:!flex-col", label: "XL - Oszlop" },
        { id: 13, value: "max-2xl:!flex-col", label: "2XL - Oszlop" },
      ],
      containerOverflow: [
        { id: 0, value: "hidden", label: "Elrejtve" },
        { id: 1, value: "visible", label: "Látható" },
        { id: 2, value: "scroll", label: "Scroll" },
        { id: 1, value: "auto", label: "Automatikus" },
      ],
      visibleOnMobile: [
        { id: 0, value: "hidden", label: "Elrejtve" },
        { id: 1, value: "visible", label: "Látható" },
      ],
      containerJustify: [
        { id: 0, value: "center", label: "Center" },
        { id: 1, value: "end", label: "End" },
        { id: 2, value: "flex-end", label: "Flex-end" },
        { id: 3, value: "flex-start", label: "Flex-start" },
        { id: 4, value: "inherit", label: "Inherit" },
        { id: 5, value: "initial", label: "Initial" },
        { id: 6, value: "left", label: "Left" },
        { id: 7, value: "normal", label: "Normal" },
        { id: 8, value: "revert", label: "Revert" },
        { id: 9, value: "right", label: "Right" },
        { id: 10, value: "space-around", label: "Space-around" },
        { id: 11, value: "space-between", label: "Space-between" },
        { id: 12, value: "space-evenly", label: "Space-evenly" },
        { id: 13, value: "start", label: "Start" },
        { id: 14, value: "stretch", label: "Stretch" },
        { id: 15, value: "unset", label: "Unset" },
      ],
      containerAlign: [
        { id: 0, value: "baseline", label: "Baseline" },
        { id: 1, value: "center", label: "Center" },
        { id: 3, value: "end", label: "End" },
        { id: 4, value: "flex-end", label: "Flex-end" },
        { id: 5, value: "flex-start", label: "Flex-start" },
        { id: 6, value: "inherit", label: "Inherit" },
        { id: 7, value: "initial", label: "Initial" },
        { id: 8, value: "normal", label: "Normal" },
        { id: 9, value: "revert", label: "Revert" },
        { id: 10, value: "self-end", label: "Self-end" },
        { id: 11, value: "self-start", label: "Self-start" },
        { id: 12, value: "start", label: "Start" },
        { id: 13, value: "stretch", label: "Stretch" },
        { id: 14, value: "unset", label: "Unset" },
      ],
      defaults: {
        type: "containerOptions",
        containerLinkColor: "#212121",
        containerLinkHoverColor: "#0891b2",
        containerBorderColor: "#0891b2",
        containerBackgroundColor: "#ffffff",
        containerBoxShadowColor: "#ffffff",
        containerBorderTop: "0",
        containerBorderRight: "0",
        containerBorderBottom: "0",
        containerBorderLeft: "0",
        containerMarginTop: "0",
        containerMarginRight: "0",
        containerMarginBottom: "0",
        containerMarginLeft: "0",
        containerPaddingTop: "0",
        containerPaddingRight: "30",
        containerPaddingBottom: "0",
        containerPaddingLeft: "30",
        containerColDistance: "10",
        containerOverflow: "hidden",
        containerBoxShadow: "false",
        containerBoxShadowVertical: "0",
        containerBoxShadowHorizontal: "0",
        containerBoxShadowBlurRadius: "",
        containerBoxShadowSpreadRadius: "",
        containerColAlignment: "space-evenly",
      },
    },
    column: {
      columnPosition: [
        { id: 0, value: "relative", label: "Relatív" },
        { id: 1, value: "absolute", label: "Abszolút" },
        { id: 2, value: "fixed", label: "Fix" },
      ],
      columnColDistance: [
        { id: 0, value: "0", label: "0" },
        { id: 1, value: "5", label: "5" },
        { id: 2, value: "10", label: "10" },
        { id: 3, value: "15", label: "15" },
        { id: 4, value: "20", label: "20" },
        { id: 5, value: "25", label: "25" },
        { id: 6, value: "30", label: "30" },
      ],
      columnBoxShadow: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      columnOrder: [
        { id: 0, value: "row", label: "Sor" },
        { id: 1, value: "column", label: "Oszlop" },
      ],
      breakpoints: [
        { id: 0, value: "sm", label: "SM" },
        { id: 1, value: "md", label: "MD" },
        { id: 2, value: "lg", label: "LG" },
        { id: 3, value: "xl", label: "XL" },
        { id: 4, value: "2xl", label: "2XL" },
      ],
      columnOrderBreakpoints: [
        { id: 0, value: "max-xxs:!flex-row", label: "XXS - Sor" },
        { id: 1, value: "max-xs:!flex-row", label: "XS - Sor" },
        { id: 2, value: "max-sm:!flex-row", label: "SM - Sor" },
        { id: 3, value: "max-md:!flex-row", label: "MD - Sor" },
        { id: 4, value: "max-lg:!flex-row", label: "LG - Sor" },
        { id: 5, value: "max-xl:!flex-row", label: "XL - Sor" },
        { id: 6, value: "max-2xl:!flex-row", label: "2XL - Sor" },
        { id: 7, value: "max-xxs:!flex-col", label: "XXS - Oszlop" },
        { id: 8, value: "max-xs:!flex-col", label: "XS - Oszlop" },
        { id: 9, value: "max-sm:!flex-col", label: "SM - Oszlop" },
        { id: 10, value: "max-md:!flex-col", label: "MD - Oszlop" },
        { id: 11, value: "max-lg:!flex-col", label: "LG - Oszlop" },
        { id: 12, value: "max-xl:!flex-col", label: "XL - Oszlop" },
        { id: 13, value: "max-2xl:!flex-col", label: "2XL - Oszlop" },
      ],
      columnOverflow: [
        { id: 0, value: "hidden", label: "Elrejtve" },
        { id: 1, value: "visible", label: "Látható" },
        { id: 2, value: "scroll", label: "Scroll" },
        { id: 1, value: "auto", label: "Automatikus" },
      ],
      visibleOnMobile: [
        { id: 0, value: "hidden", label: "Elrejtve" },
        { id: 1, value: "visible", label: "Látható" },
      ],
      columnJustify: [
        { id: 0, value: "center", label: "Center" },
        { id: 1, value: "end", label: "End" },
        { id: 2, value: "flex-end", label: "Flex-end" },
        { id: 3, value: "flex-start", label: "Flex-start" },
        { id: 4, value: "inherit", label: "Inherit" },
        { id: 5, value: "initial", label: "Initial" },
        { id: 6, value: "left", label: "Left" },
        { id: 7, value: "normal", label: "Normal" },
        { id: 8, value: "revert", label: "Revert" },
        { id: 9, value: "right", label: "Right" },
        { id: 10, value: "space-around", label: "Space-around" },
        { id: 11, value: "space-between", label: "Space-between" },
        { id: 12, value: "space-evenly", label: "Space-evenly" },
        { id: 13, value: "start", label: "Start" },
        { id: 14, value: "stretch", label: "Stretch" },
        { id: 15, value: "unset", label: "Unset" },
      ],
      columnAlign: [
        { id: 0, value: "baseline", label: "Baseline" },
        { id: 1, value: "center", label: "Center" },
        { id: 3, value: "end", label: "End" },
        { id: 4, value: "flex-end", label: "Flex-end" },
        { id: 5, value: "flex-start", label: "Flex-start" },
        { id: 6, value: "inherit", label: "Inherit" },
        { id: 7, value: "initial", label: "Initial" },
        { id: 8, value: "normal", label: "Normal" },
        { id: 9, value: "revert", label: "Revert" },
        { id: 10, value: "self-end", label: "Self-end" },
        { id: 11, value: "self-start", label: "Self-start" },
        { id: 12, value: "start", label: "Start" },
        { id: 13, value: "stretch", label: "Stretch" },
        { id: 14, value: "unset", label: "Unset" },
      ],
      borderStyle: [
        { id: 0, value: "dotted", label: "Dotted" },
        { id: 1, value: "dashed", label: "Dashed" },
        { id: 2, value: "solid", label: "Solid" },
        { id: 3, value: "double", label: "Double" },
        { id: 4, value: "groove", label: "Groove" },
        { id: 5, value: "ridge", label: "Ridge" },
        { id: 6, value: "inset", label: "Inset" },
        { id: 7, value: "outSet", label: "Outset" },
        { id: 8, value: "none", label: "None" },
        { id: 9, value: "hidden", label: "Hidden" },
      ],
      defaults: {
        type: "columnOptions",
        columnLinkColor: "#212121",
        columnLinkHoverColor: "#0891b2",
        columnBorderColor: "#0891b2",
        columnBackgroundColor: "#ffffff",
        columnBoxShadowColor: "#ffffff",
        columnBorderTop: "0",
        columnBorderRight: "0",
        columnBorderBottom: "0",
        columnBorderLeft: "0",
        columnMarginTop: "0",
        columnMarginRight: "0",
        columnMarginBottom: "0",
        columnMarginLeft: "0",
        columnPaddingTop: "0",
        columnPaddingRight: "30",
        columnPaddingBottom: "0",
        columnPaddingLeft: "30",
        columnColDistance: "10",
        columnOverflow: "hidden",
        columnBoxShadow: "false",
        columnBoxShadowVertical: "0",
        columnBoxShadowHorizontal: "0",
        columnBoxShadowBlurRadius: "",
        columnBoxShadowSpreadRadius: "",
        columnColAlignment: "space-evenly",
        columnPosition: "relative",
        columnMaxHeight: "inherit",
      },
    },
    contentBox: {
      boxShadow: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
    },
    people: {
      layoutTypes: [{ id: 0, value: "base", label: "Alap" }],
      orderBy: [
        { id: 0, value: "date", label: "Dátum" },
        { id: 1, value: "name", label: "Személy neve" },
      ],
      displayedProperties: [
        { id: 0, value: "name", label: "Személy név" },
        { id: 1, value: "namelug", label: "Személy url" },
        { id: 2, value: "location", label: "Telephely" },
        { id: 3, value: "excerpt", label: "Leírás röviden" },
        { id: 4, value: "description", label: "Leírás hosszan" },
        { id: 5, value: "featuredImage", label: "Kép" },
        { id: 6, value: "specialization", label: "Szaktárgy" },
        {
          id: 7,
          value: "artForm",
          label: "Művészeti ág",
        },
      ],
      showDate: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      showReadMore: [
        { id: 0, value: "true", label: "Igen" },
        { id: 1, value: "false", label: "Nem" },
      ],
      peopleLength: [
        { id: 0, value: "all", label: "Összes" },
        { id: 1, value: "1", label: "1" },
        { id: 2, value: "2", label: "2" },
        { id: 3, value: "3", label: "3" },
        { id: 4, value: "4", label: "4" },
        { id: 5, value: "5", label: "5" },
        { id: 6, value: "6", label: "6" },
        { id: 7, value: "7", label: "7" },
        { id: 8, value: "8", label: "8" },
        { id: 9, value: "9", label: "9" },
        { id: 10, value: "10", label: "10" },
        { id: 11, value: "11", label: "11" },
        { id: 12, value: "12", label: "12" },
        { id: 13, value: "13", label: "13" },
        { id: 14, value: "14", label: "14" },
        { id: 15, value: "15", label: "15" },
        { id: 16, value: "16", label: "16" },
        { id: 17, value: "17", label: "17" },
        { id: 18, value: "18", label: "17" },
        { id: 19, value: "19", label: "19" },
        { id: 20, value: "20", label: "20" },
        { id: 21, value: "21", label: "21" },
        { id: 22, value: "22", label: "22" },
        { id: 23, value: "23", label: "23" },
        { id: 24, value: "24", label: "24" },
        { id: 25, value: "25", label: "25" },
      ],
    },
    artform: {
      layoutTypes: [{ id: 0, value: "base", label: "Alap" }],
    },
  },
  accessLevels: [
    { id: 0, value: "site-admin", label: "Site-admin" },
    { id: 1, value: "admin", label: "Admin" },
    { id: 2, value: "user", label: "User" },
  ],
  deliveryAreas: [
    { id: 0, value: "budapest", label: "Budapest" },
    {
      id: 1,
      value: [
        "Szentendre",
        "Budakalász",
        "Leányfalu",
        "Dunakeszi",
        "Üröm",
        "Solymár",
        "Pilisvörösvár",
        "Fót",
        "Veresegyház",
        "Kistarcsa",
        "Csömör",
        "Vecsés",
        "Nagykovácsi",
        "Budakeszi",
        "Budaörs",
        "Törökbálint",
        "Érd",
      ],
      label: "Agglomeráció",
    },
    { id: 2, value: "orszagos", label: "Futárszolgálat" },
    { id: 3, value: "szemelyes", label: "Személyes" },
  ],
  weekDays: [
    { value: "monday", label: "Hétfő" },
    { value: "tuesday", label: "Kedd" },
    { value: "wednesday", label: "Szerda" },
    { value: "thursday", label: "Csütörtök" },
    { value: "friday", label: "Péntek" },
    { value: "saturday", label: "Szombat" },
    { value: "sunday", label: "Vasárnap" },
  ],
  modalTypeMap: {
    container: "showContainerModal",
    blog: "showBlogModal",
    product: "showProductModal",
  },
  settings: {
    layout: [
      { id: 0, value: "full", label: "Teljes szélességű" },
      { id: 1, value: "boxed", label: "Boxed" },
    ],
    pageBackground: [
      {
        id: 0,
        value: "rgba(255, 255, 255, 1)",
        label: "Alapértelmezett - fehér",
      },
    ],
    contentBackground: [
      {
        id: 0,
        value: "rgba(255, 255, 255, 1)",
        label: "Alapértelmezett - fehér",
      },
    ],
    fontFamily: [
      {
        id: 0,
        value: "open-sans",
        label: "Open Sans, Helvetica, Arial, sans-serif",
      },
      {
        id: 1,
        value: "arial",
        label: "'Arial Black', Gadget, sans-serif",
      },
      {
        id: 2,
        value: "bookman",
        label: "'Bookman Old Style', serif",
      },
      {
        id: 3,
        value: "comic",
        label: "'Comic Sans MS', cursive",
      },
      { id: 4, value: "courier", label: "Courier, monospace" },
      { id: 5, value: "garamond", label: "Garamond, serif" },
      { id: 6, value: "georgia", label: "Georgia, serif" },
      {
        id: 7,
        value: "impact",
        label: "Impact, Charcoal, sans-serif",
      },
      {
        id: 8,
        value: "lucida",
        label: "'Lucida Console', Monaco, monospace",
      },
      {
        id: 9,
        value: "unicode",
        label: "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
      },
      {
        id: 10,
        value: "tahoma",
        label: "'Tahoma', Geneva, sans-serif",
      },
      {
        id: 11,
        value: "serif",
        label: "'MS Serif', 'New York', sans-serif",
      },
      {
        id: 12,
        value: "palatino",
        label: "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
      },
      {
        id: 13,
        value: "times",
        label: "'Times New Roman', Times,serif",
      },
      {
        id: 14,
        value: "trebuchet",
        label: "'Trebuchet MS', Helvetica, sans-serif",
      },
      {
        id: 15,
        value: "vardana",
        label: "Verdana, Geneva, sans-serif",
      },
      {
        id: 17,
        value: "'Roboto Flex', Geneva, sans-serif",
        label: "'Roboto Flex', Geneva, sans-serif",
      },
      { id: 18, label: "Lora", value: "Lora" },
      { id: 19, label: "DIN Pro", value: "DIN Pro" },
      {
        id: 20,
        value: "'Inter', sans-serif",
        label: "'Inter', sans-serif",
      },
      {
        id: 21,
        value: "'Playfair Display', serif",
        label: "'Playfair Display', serif",
      },
    ],
    fontWeight: [
      { id: 0, value: "100", label: "100" },
      { id: 1, value: "200", label: "200" },
      { id: 2, value: "300", label: "300" },
      { id: 3, value: "400", label: "400" },
      { id: 4, value: "500", label: "500" },
      { id: 5, value: "600", label: "600" },
      { id: 6, value: "700", label: "700" },
      { id: 7, value: "800", label: "800" },
      { id: 8, value: "900", label: "900" },
      { id: 9, value: "bold", label: "bold" },
      { id: 10, value: "bolder", label: "bolder" },
      { id: 11, value: "lighter", label: "lighter" },
      { id: 12, value: "normal", label: "normal" },
      { id: 13, value: "inherit", label: "inherit" },
      { id: 14, value: "initial", label: "initial" },
      { id: 15, value: "revert", label: "revert" },
      { id: 16, value: "revert-layer", label: "revert-layer" },
      { id: 17, value: "unset", label: "unset" },
    ],
  },
  validators: {
    list: [
      { id: 0, value: "VALIDATOR_REQUIRE", label: "VALIDATOR_REQUIRE" },
      // { id: 2, value: "VALIDATOR_ATU()", label: "VALIDATOR_ATU" },
      // { id: 3, value: "VALIDATOR_MINLENGTH()", label: "VALIDATOR_MINLENGTH" },
      // { id: 4, value: "VALIDATOR_MAXLENGTH()", label: "VALIDATOR_MAXLENGTH" },
      // { id: 5, value: "VALIDATOR_MINWORDCNT()", label: "VALIDATOR_MINWORDCNT" },
      // { id: 6, value: "VALIDATOR_MIN()", label: "VALIDATOR_MIN" },
      // { id: 7, value: "VALIDATOR_MAX()", label: "VALIDATOR_MAX" },
      { id: 8, value: "VALIDATOR_EMAIL", label: "VALIDATOR_EMAIL" },
      { id: 9, value: "VALIDATOR_NUMBER", label: "VALIDATOR_NUMBER" },
      // { id: 10, value: "VALIDATOR_NUMRANGE()", label: "VALIDATOR_NUMRANGE" },
      // { id: 11, value: "VALIDATOR_PASSWORD()", label: "VALIDATOR_PASSWORD" },
      { id: 12, value: "VALIDATOR_PHONE_HU", label: "VALIDATOR_PHONE_HU" },
      // { id: 13, value: "VALIDATOR_PHONE_AT()", label: "VALIDATOR_PHONE_AT" },
      {
        id: 14,
        value: "VALIDATOR_TAXNUMBER_HU",
        label: "VALIDATOR_TAXNUMBER_HU",
      },
    ],
  },
  inputTypes: {
    list: [
      { id: 0, value: "email", label: "email" },
      { id: 1, value: "number", label: "number" },
      { id: 2, value: "password", label: "password" },
      { id: 3, value: "tel", label: "tel" },
      { id: 4, value: "text", label: "text" },
    ],
  },
  fontFamily: [
    {
      id: 0,
      value: "open-sans",
      label: "Open Sans, Helvetica, Arial, sans-serif",
    },
    {
      id: 1,
      value: "arial",
      label: "'Arial Black', Gadget, sans-serif",
    },
    {
      id: 2,
      value: "bookman",
      label: "'Bookman Old Style', serif",
    },
    {
      id: 3,
      value: "comic",
      label: "'Comic Sans MS', cursive",
    },
    { id: 4, value: "courier", label: "Courier, monospace" },
    { id: 5, value: "garamond", label: "Garamond, serif" },
    { id: 6, value: "georgia", label: "Georgia, serif" },
    {
      id: 7,
      value: "impact",
      label: "Impact, Charcoal, sans-serif",
    },
    {
      id: 8,
      value: "lucida",
      label: "'Lucida Console', Monaco, monospace",
    },
    {
      id: 9,
      value: "unicode",
      label: "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
    },
    {
      id: 10,
      value: "tahoma",
      label: "'Tahoma', Geneva, sans-serif",
    },
    {
      id: 11,
      value: "serif",
      label: "'MS Serif', 'New York', sans-serif",
    },
    {
      id: 12,
      value: "palatino",
      label: "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
    },
    {
      id: 13,
      value: "times",
      label: "'Times New Roman', Times,serif",
    },
    {
      id: 14,
      value: "trebuchet",
      label: "'Trebuchet MS', Helvetica, sans-serif",
    },
    {
      id: 15,
      value: "vardana",
      label: "Verdana, Geneva, sans-serif",
    },
    {
      id: 17,
      value: "'Roboto Flex', Geneva, sans-serif",
      label: "'Roboto Flex', Geneva, sans-serif",
    },
    { id: 18, label: "Lora", value: "Lora" },
    { id: 19, label: "DIN Pro", value: "DIN Pro" },
    {
      id: 20,
      value: "'Inter', sans-serif",
      label: "'Inter', sans-serif",
    },
    {
      id: 21,
      value: "'Playfair Display', serif",
      label: "'Playfair Display', serif",
    },
  ],
  textAlignment: [
    { id: 0, value: "left", label: "Balra zárt" },
    { id: 1, value: "center", label: "Középen" },
    { id: 2, value: "right", label: "Jobbra zárt" },
  ],
  contentOrder: [
    { id: 0, value: "row", label: "Sor" },
    { id: 1, value: "column", label: "Oszlop" },
  ],
  breakpoints: [
    { id: 0, value: "sm", label: "SM" },
    { id: 1, value: "md", label: "MD" },
    { id: 2, value: "lg", label: "LG" },
    { id: 3, value: "xl", label: "XL" },
    { id: 4, value: "2xl", label: "2XL" },
  ],
  orderBreakpoints: [
    { id: 0, value: "max-xxs:!flex-row", label: "XXS - Sor" },
    { id: 1, value: "max-xs:!flex-row", label: "XS - Sor" },
    { id: 2, value: "max-sm:!flex-row", label: "SM - Sor" },
    { id: 3, value: "max-md:!flex-row", label: "MD - Sor" },
    { id: 4, value: "max-lg:!flex-row", label: "LG - Sor" },
    { id: 5, value: "max-xl:!flex-row", label: "XL - Sor" },
    { id: 6, value: "max-2xl:!flex-row", label: "2XL - Sor" },
    { id: 7, value: "max-xxs:!flex-col", label: "XXS - Oszlop" },
    { id: 8, value: "max-xs:!flex-col", label: "XS - Oszlop" },
    { id: 9, value: "max-sm:!flex-col", label: "SM - Oszlop" },
    { id: 10, value: "max-md:!flex-col", label: "MD - Oszlop" },
    { id: 11, value: "max-lg:!flex-col", label: "LG - Oszlop" },
    { id: 12, value: "max-xl:!flex-col", label: "XL - Oszlop" },
    { id: 13, value: "max-2xl:!flex-col", label: "2XL - Oszlop" },
  ],
  overflow: [
    { id: 0, value: "hidden", label: "Elrejtve" },
    { id: 1, value: "visible", label: "Látható" },
    { id: 2, value: "scroll", label: "Scroll" },
    { id: 3, value: "auto", label: "Automatikus" },
  ],
  visibleOnMobile: [
    { id: 0, value: "hidden", label: "Elrejtve" },
    { id: 1, value: "visible", label: "Látható" },
  ],
  justify: [
    { id: 0, value: "center", label: "Center" },
    { id: 1, value: "end", label: "End" },
    { id: 2, value: "flex-end", label: "Flex-end" },
    { id: 3, value: "flex-start", label: "Flex-start" },
    { id: 4, value: "inherit", label: "Inherit" },
    { id: 5, value: "initial", label: "Initial" },
    { id: 6, value: "left", label: "Left" },
    { id: 7, value: "normal", label: "Normal" },
    { id: 8, value: "revert", label: "Revert" },
    { id: 9, value: "right", label: "Right" },
    { id: 10, value: "space-around", label: "Space-around" },
    { id: 11, value: "space-between", label: "Space-between" },
    { id: 12, value: "space-evenly", label: "Space-evenly" },
    { id: 13, value: "start", label: "Start" },
    { id: 14, value: "stretch", label: "Stretch" },
    { id: 15, value: "unset", label: "Unset" },
  ],
  align: [
    { id: 0, value: "baseline", label: "Baseline" },
    { id: 1, value: "center", label: "Center" },
    { id: 3, value: "end", label: "End" },
    { id: 4, value: "flex-end", label: "Flex-end" },
    { id: 5, value: "flex-start", label: "Flex-start" },
    { id: 6, value: "inherit", label: "Inherit" },
    { id: 7, value: "initial", label: "Initial" },
    { id: 8, value: "normal", label: "Normal" },
    { id: 9, value: "revert", label: "Revert" },
    { id: 10, value: "self-end", label: "Self-end" },
    { id: 11, value: "self-start", label: "Self-start" },
    { id: 12, value: "start", label: "Start" },
    { id: 13, value: "stretch", label: "Stretch" },
    { id: 14, value: "unset", label: "Unset" },
  ],
  imageAlign: [
    { id: 0, value: "left", label: "Balra zárt" },
    { id: 1, value: "center", label: "Középre zárt" },
    { id: 2, value: "right", label: "Jobbra zárt" },
  ],
  borderStyle: [
    { id: 0, value: "dotted", label: "Dotted" },
    { id: 1, value: "dashed", label: "Dashed" },
    { id: 2, value: "solid", label: "Solid" },
    { id: 3, value: "double", label: "Double" },
    { id: 4, value: "groove", label: "Groove" },
    { id: 5, value: "ridge", label: "Ridge" },
    { id: 6, value: "inset", label: "Inset" },
    { id: 7, value: "outSet", label: "Outset" },
    { id: 8, value: "none", label: "None" },
    { id: 9, value: "hidden", label: "Hidden" },
  ],
  textTypes: [
    { id: 0, value: "h1", label: "H1" },
    { id: 1, value: "h2", label: "H2" },
    { id: 2, value: "h3", label: "H3" },
    { id: 3, value: "h4", label: "H4" },
    { id: 4, value: "h5", label: "H5" },
    { id: 5, value: "h6", label: "H6" },
    { id: 6, value: "p", label: "P" },
    { id: 7, value: "span", label: "SPAN" },
  ],
  position: [
    { id: 0, value: "relative", label: "Relatív" },
    { id: 1, value: "absolute", label: "Abszolút" },
    { id: 2, value: "fixed", label: "Fix" },
  ],
  linkTarget: [
    { id: 0, value: "_self", label: "Ugyanott nyílik a link" },
    { id: 1, value: "_blank", label: "Másik oldalt nyit a link" },
  ],
  imageTypes: [
    { id: 0, value: "image", label: "Kép" },
    { id: 1, value: "background", label: "Háttér" },
  ],
  borderPositions: [
    { id: 0, value: "top", label: "Felül" },
    { id: 1, value: "right", label: "Jobbra" },
    { id: 2, value: "bottom", label: "Alul" },
    { id: 3, value: "left", label: "Balra" },
  ],
  layoutDisplay: [
    { id: 0, value: "product__layout", label: "Termék layout" },
    { id: 1, value: "flex", label: "Flex layout" },
    { id: 2, value: "news__layout", label: "Hírek layout" },
    { id: 3, value: "news__left__layout", label: "Hírek - bal - layout" },
  ],
  fontWeight: [
    { id: 0, value: "100", label: "100" },
    { id: 1, value: "200", label: "200" },
    { id: 2, value: "300", label: "300" },
    { id: 3, value: "400", label: "400" },
    { id: 4, value: "500", label: "500" },
    { id: 5, value: "600", label: "600" },
    { id: 6, value: "700", label: "700" },
    { id: 7, value: "800", label: "800" },
    { id: 8, value: "900", label: "900" },
    { id: 9, value: "bold", label: "bold" },
    { id: 10, value: "bolder", label: "bolder" },
    { id: 11, value: "lighter", label: "lighter" },
    { id: 12, value: "normal", label: "normal" },
    { id: 13, value: "inherit", label: "inherit" },
    { id: 14, value: "initial", label: "initial" },
    { id: 15, value: "revert", label: "revert" },
    { id: 16, value: "revert-layer", label: "revert-layer" },
    { id: 17, value: "unset", label: "unset" },
  ],
  bool: [
    { id: 0, value: "true", label: "Igen" },
    { id: 1, value: "false", label: "Nem" },
  ],
  animation: [
    { id: 0, value: "", label: "None" },
    { id: 1, value: "slide-in-left", label: "Slide in from left" },
    {
      id: 2,
      value: "slide-in-right",
      label: "Slide in from right",
    },
    { id: 3, value: "slide-in-top", label: "Slide in from top" },
    {
      id: 4,
      value: "slide-in-bottom",
      label: "Slide in from bottom",
    },
    { id: 5, value: "tracking-in-expand", label: "tracking-in-expand" },
    {
      id: 6,
      value: "tracking-in-expand-fwd",
      label: "tracking-in-expand-fwd",
    },
    {
      id: 7,
      value: "tracking-in-expand-fwd-top",
      label: "tracking-in-expand-fwd-top",
    },
    {
      id: 8,
      value: "tracking-in-expand-fwd-bottom",
      label: "tracking-in-expand-fwd-bottom",
    },
    { id: 9, value: "tracking-in-contract", label: "tracking-in-contract" },
    {
      id: 10,
      value: "tracking-in-contract-bck",
      label: "tracking-in-contract-bck",
    },
    {
      id: 11,
      value: "tracking-in-contract-bck-top",
      label: "tracking-in-contract-bck-top",
    },
    {
      id: 12,
      value: "tracking-in-contract-bck-bottom",
      label: "tracking-in-contract-bck-bottom",
    },
    { id: 13, value: "text-focus-in ", label: "text-focus-in" },
    { id: 14, value: "focus-in-expand", label: "focus-in-expand" },
    { id: 15, value: "focus-in-expand-fwd", label: "focus-in-expand-fwd" },
    { id: 16, value: "focus-in-contract", label: "focus-in-contract" },
    {
      id: 17,
      value: "focus-in-contract-bck",
      label: "focus-in-contract-bck",
    },
    // attention
    { id: 18, value: "bounce-top", label: "bounce-top" },
    { id: 19, value: "bounce-bottom", label: "bounce-bottom" },
    { id: 20, value: "bounce-left", label: "bounce-left" },
    { id: 21, value: "bounce-right", label: "bounce-right" },
    { id: 22, value: "heartbeat", label: "heartbeat" },
    { id: 23, value: "ping", label: "ping" },
    // background
    { id: 24, value: "kenburns-top", label: "kenburns-top" },
    { id: 25, value: "kenburns-top-right", label: "kenburns-top-right" },
    { id: 26, value: "kenburns-right", label: "kenburns-right" },
    {
      id: 27,
      value: "kenburns-bottom-right",
      label: "kenburns-bottom-right",
    },
    { id: 28, value: "kenburns-bottom", label: "kenburns-bottom" },
    {
      id: 29,
      value: "kenburns-bottom-left",
      label: "kenburns-bottom-left",
    },
    { id: 30, value: "kenburns-left", label: "kenburns-left" },
    { id: 31, value: "kenburns-top-left", label: "kenburns-top-left" },
    { id: 32, value: "bg-pan-left", label: "bg-pan-left" },
    { id: 33, value: "bg-pan-top", label: "bg-pan-top" },
    { id: 34, value: "color-change-2x", label: "color-change-2x" },
    // entrances
    { id: 35, value: "rotate-in-2-cw", label: "rotate-in-2-cw" },
    { id: 36, value: "flip-in-ver-right", label: "flip-in-ver-right" },
    { id: 37, value: "slit-in-vertical", label: "slit-in-vertical" },
    { id: 38, value: "slit-in-horizontal", label: "slit-in-horizontal" },
    { id: 39, value: "slit-in-diagonal-1", label: "slit-in-diagonal-1" },
    { id: 40, value: "slide-in-bck-center", label: "slide-in-bck-center" },
    { id: 41, value: "slide-in-bck-top", label: "slide-in-bck-top" },
    {
      id: 42,
      value: "slide-in-blurred-top",
      label: "slide-in-blurred-top",
    },
    {
      id: 43,
      value: "slide-in-blurred-right",
      label: "slide-in-blurred-right",
    },
    {
      id: 44,
      value: "slide-in-elliptic-top-fwd",
      label: "slide-in-elliptic-top-fwd",
    },
    {
      id: 45,
      value: "slide-in-elliptic-top-bck",
      label: "slide-in-elliptic-top-bck",
    },
    {
      id: 46,
      value: "slide-in-elliptic-right-fwd",
      label: "slide-in-elliptic-right-fwd",
    },
    { id: 47, value: "bounce-in-top", label: "bounce-in-top" },
    { id: 48, value: "bounce-in-right", label: "bounce-in-right" },
    { id: 49, value: "bounce-in-fwd", label: "bounce-in-fwd" },
    { id: 50, value: "roll-in-left", label: "roll-in-left" },
    { id: 51, value: "roll-in-right", label: "roll-in-right" },
    { id: 52, value: "swing-in-top-fwd", label: "swing-in-top-fwd" },
    { id: 53, value: "swing-in-top-bck", label: "swing-in-top-bck" },
    { id: 54, value: "swing-in-right-fwd", label: "swing-in-right-fwd" },
  ],
  hasLayer: [
    { id: 0, value: "nolayer", label: "Nincs layer a képen" },
    { id: 1, value: "layer", label: "Van layer a képen" },
  ],
  slidesPerView: [
    { id: 1, value: "1", label: "1" },
    { id: 2, value: "2", label: "2" },
    { id: 3, value: "3", label: "3" },
    { id: 4, value: "4", label: "4" },
    { id: 5, value: "5", label: "5" },
    { id: 6, value: "6", label: "6" },
  ],
  spaceBetween: [
    { id: 0, value: "0", label: "0" },
    { id: 1, value: "10", label: "10" },
    { id: 2, value: "20", label: "20" },
    { id: 3, value: "30", label: "30" },
    { id: 4, value: "40", label: "40" },
    { id: 5, value: "50", label: "50" },
  ],
  imageTypes: [
    { id: 0, value: "image", label: "Kép" },
    { id: 1, value: "background", label: "Háttér" },
  ],
  backgroundPosition: [
    { id: 0, value: "inherit", label: "Inherit" },
    { id: 1, value: "fixed", label: "Fixed" },
    { id: 2, value: "local", label: "local" },
    { id: 3, value: "scroll", label: "scroll" },
    { id: 4, value: "unset", label: "unset" },
  ],
  objectFit: [
    { id: 0, value: "contain", label: "Contain" },
    { id: 1, value: "cover", label: "Cover" },
    { id: 2, value: "fill", label: "Fill" },
    { id: 3, value: "inherit", label: "Inherit" },
    { id: 4, value: "initial", label: "Initial" },
    { id: 5, value: "none", label: "None" },
    { id: 6, value: "revert", label: "Revert" },
    { id: 7, value: "scale-down", label: "Scale down" },
    { id: 8, value: "unset", label: "Unset" },
  ],
  objectPosition: [
    { id: 0, value: "bottom", label: "Bottom" },
    { id: 1, value: "center", label: "Center" },
    { id: 2, value: "inherit", label: "Inherit" },
    { id: 3, value: "initial", label: "Initial" },
    { id: 4, value: "left", label: "Left" },
    { id: 5, value: "revert", label: "Revert" },
    { id: 6, value: "right", label: "Right" },
    { id: 7, value: "top", label: "Top" },
    { id: 8, value: "unset", label: "Unset" },
  ],
  bloglayoutTypes: [
    { id: 0, value: "large", label: "Nagy képpel" },
    {
      id: 1,
      value: "text-over-image",
      label: "Nagy képpel - szöveg a képen",
    },
    { id: 2, value: "base", label: "Alap" },
    { id: 3, value: "left", label: "Kép bal - szöveg jobb oldalon" },
    { id: 4, value: "right", label: "Kép jobb - szöveg bal oldalon" },
    { id: 5, value: "noimage", label: "Kép nélkül" },
  ],
  postsLength: [
    { id: 1, value: "1", label: "1" },
    { id: 2, value: "2", label: "2" },
    { id: 3, value: "3", label: "3" },
    { id: 4, value: "4", label: "4" },
    { id: 5, value: "5", label: "5" },
    { id: 6, value: "6", label: "6" },
    { id: 7, value: "7", label: "7" },
    { id: 8, value: "8", label: "8" },
    { id: 9, value: "9", label: "9" },
    { id: 10, value: "10", label: "10" },
    { id: 11, value: "11", label: "11" },
    { id: 12, value: "12", label: "12" },
    { id: 13, value: "13", label: "13" },
    { id: 14, value: "14", label: "14" },
    { id: 15, value: "15", label: "15" },
    { id: 16, value: "16", label: "16" },
    { id: 17, value: "17", label: "17" },
    { id: 18, value: "18", label: "17" },
    { id: 19, value: "19", label: "19" },
    { id: 20, value: "20", label: "20" },
    { id: 21, value: "21", label: "21" },
    { id: 22, value: "22", label: "22" },
    { id: 23, value: "23", label: "23" },
    { id: 24, value: "24", label: "24" },
    { id: 25, value: "25", label: "25" },
  ],
  postsOrderBy: [
    { id: 0, value: "date", label: "Dátum" },
    { id: 1, value: "post-title", label: "Bejegyzés címe" },
    // { id: 2, value: "author", label: "Szerző" },
  ],
  postContentLength: [
    { id: 0, value: "excerpt", label: "Rövid szöveg" },
    { id: 1, value: "full", label: "Teljes szöveg" },
    { id: 2, value: "no-text", label: "Szöveg nélkül" },
  ],
  productLayoutTypes: [
    { id: 0, value: "large", label: "Nagy képpel" },
    { id: 1, value: "base", label: "Alap" },
    // { id: 2, value: "left", label: "Kép bal - szöveg jobb oldalon" },
    // { id: 3, value: "right", label: "Kép jobb - szöveg bal oldalon" },
    // { id: 4, value: "noimage", label: "Kép nélkül" },
  ],
  productLength: [
    { id: 1, value: "1", label: "1" },
    { id: 2, value: "2", label: "2" },
    { id: 3, value: "3", label: "3" },
    { id: 4, value: "4", label: "4" },
    { id: 5, value: "5", label: "5" },
    { id: 6, value: "6", label: "6" },
    { id: 7, value: "7", label: "7" },
    { id: 8, value: "8", label: "8" },
    { id: 9, value: "9", label: "9" },
    { id: 10, value: "10", label: "10" },
    { id: 11, value: "11", label: "11" },
    { id: 12, value: "12", label: "12" },
    { id: 13, value: "13", label: "13" },
    { id: 14, value: "14", label: "14" },
    { id: 15, value: "15", label: "15" },
    { id: 16, value: "16", label: "16" },
    { id: 17, value: "17", label: "17" },
    { id: 18, value: "18", label: "17" },
    { id: 19, value: "19", label: "19" },
    { id: 20, value: "20", label: "20" },
    { id: 21, value: "21", label: "21" },
    { id: 22, value: "22", label: "22" },
    { id: 23, value: "23", label: "23" },
    { id: 24, value: "24", label: "24" },
    { id: 25, value: "25", label: "25" },
  ],
  productsOrderBy: [
    { id: 0, value: "date", label: "Dátum" },
    { id: 1, value: "product-title", label: "Termék neve" },
    // { id: 2, value: "author", label: "Szerző" },
  ],
  productDisplayedProperties: [
    { id: 0, value: "productTitle", label: "Termék név" },
    { id: 1, value: "productSlug", label: "Termék url" },
    { id: 2, value: "productTitleLink", label: "Title link - SEO" },
    { id: 3, value: "productTags", label: "Termék címkék" },
    { id: 4, value: "productItemNumber", label: "Termék azonosító" },
    { id: 5, value: "productPackType", label: "Kiszerelés" },
    { id: 6, value: "productSize", label: "Termék mérete" },
    {
      id: 7,
      value: "productQtyPerPack",
      label: "Mennyiség - csomag",
    },
    {
      id: 8,
      value: "productQtyPerCarton",
      label: "Mennyiség - karton",
    },
    { id: 9, value: "productMaterial", label: "Termék anyaga" },
    {
      id: 12,
      value: "productPieceWebshopPrice",
      label: "Termék webshop ár - nettó",
    },
    { id: 13, value: "productDescription", label: "Termék leírás" },
    { id: 14, value: "productCategory", label: "Termék kategóriák" },
    { id: 15, value: "productFeaturedImage", label: "Termék kép" },
    { id: 16, value: "productContent", label: "Termék elemek" },
    { id: 17, value: "productDiscount", label: "Kedvezmény" },
    { id: 18, value: "productVat", label: "Áfa érték - %" },
    { id: 19, value: "minQty", label: "Minimum rendelhető" },
    { id: 20, value: "connectedProducts", label: "Kapcsolódó termékek" },
    { id: 21, value: "productCerts", label: "Tanúsítványok" },
    { id: 22, value: "createdAt", label: "Létrehozva" },
    { id: 23, value: "updatedAt", label: "Frissítve" },
    { id: 24, value: "isActive", label: "Aktív" },
    { id: 25, value: "isLatest", label: "Legújabb" },
    { id: 26, value: "isEmphasized", label: "Kiemelt" },
    { id: 27, value: "inStock", label: "Raktáron" },
  ],
  productCategoryOrderBy: [
    { id: 0, value: "date", label: "Dátum" },
    {
      id: 1,
      value: "productCategoryTitle",
      label: "Termék kategória neve",
    },
    { id: 2, value: "sorting", label: "Termék kategória sorrend" },
  ],
  buttonSizes: [
    { id: 0, value: "xs", label: "Kicsi" },
    { id: 1, value: "base", label: "Normál" },
    { id: 2, value: "lg", label: "Nagy" },
    { id: 3, value: "xl", label: "Óriási" },
  ],
  separatorDesign: [
    { id: 0, value: "dotted", label: "Dotted" },
    { id: 1, value: "dashed", label: "Dashed" },
    { id: 2, value: "solid", label: "Solid" },
    { id: 3, value: "double", label: "Double" },
    { id: 4, value: "groove", label: "Groove" },
    { id: 5, value: "ridge", label: "Ridge" },
    { id: 6, value: "inset", label: "Inset" },
    { id: 7, value: "outSet", label: "Outset" },
    { id: 8, value: "none", label: "None" },
    { id: 9, value: "hidden", label: "Hidden" },
  ],
  separatorPosition: [
    { id: 0, value: "left", label: "Bal" },
    { id: 1, value: "center", label: "Közép" },
    { id: 2, value: "right", label: "Jobb" },
  ],
  productSliderLayouts: [
    { id: 0, value: "large", label: "Kép+Terméknév+Ár" },
    { id: 1, value: "base", label: "Alap" },
  ],
  columnLayoutMode: [
    { id: 0, value: "flex", label: "Flexbox" },
    { id: 1, value: "grid", label: "Grid" },
  ],
  containerLayoutMode: [
    { id: 0, value: "flex", label: "Flexbox" },
    { id: 1, value: "grid", label: "Grid" },
  ],
  gridSpans: {
    col: {
      sm: 12,
      md: 6,
      lg: 4,
      xl: 3,
    },
    row: {
      sm: 1,
      md: 2,
      lg: 2,
      xl: 2,
    },
  },
  gridLayoutMode: [
    { value: "template", label: "grid-template-columns" },
    { value: "responsive", label: "Tailwind responsive columns" },
  ],
  imageSizeType: [
    { id: 0, label: "Arány", value: "ratio" },
    { id: 1, label: "Pixel", value: "pixel" },
  ],
};
