import React, { createContext, useContext, useState } from "react";

const ModalContext = createContext();

export const ModalProvider = ({ children }) => {
  const [modals, setModals] = useState({});
  const toggleModal = (modalName) => {
    setModals((prev) => ({
      ...prev,
      [modalName]: !prev[modalName],
    }));
  };

  const isModalOpen = (modalName) => !!modals[modalName];

  return (
    <ModalContext.Provider value={{ modals, toggleModal, isModalOpen }}>
      {children}
    </ModalContext.Provider>
  );
};

export const useModalManager = () => useContext(ModalContext);
