"use client";
import { useContext, useEffect, useState, createContext } from "react";
import ApiCall from "@/api/api-calls";

const ExchangeRateContext = createContext();

const ExchangeRateProvider = ({ children }) => {
  const [exchangeRate, setExchangeRate] = useState(null);
  const [isLoading, setIsLoading] = useState(true);
  useEffect(() => {
    const fetchRate = async () => {
      const response = await ApiCall.globals.getCurrentExchangeRate();
      console.log("response", response);
      if (response.status === 200) {
        setExchangeRate(response?.data?.body?.exchangeRate?.exchangeRate);
      } else {
        setExchangeRate(400);
      }
    };
    fetchRate();
  }, []);
  return (
    <ExchangeRateContext.Provider value={exchangeRate}>
      {children}
    </ExchangeRateContext.Provider>
  );
};
export const useExchangeRate = () => useContext(ExchangeRateContext);

export { ExchangeRateContext, ExchangeRateProvider };
