// ProductGroupTabs.jsx
import React from "react";

const UserTabs = ({ activeTab, onTabChange }) => {
  return (
    <div className="flex w-full border-b border-gray-300 mb-4">
      <button
        onClick={() => onTabChange(1)}
        className={`px-4 py-2 border-t border-l border-r border-gray-300 ${
          activeTab === 1 ? "bg-green-500 text-white" : ""
        }`}>
        Felhasználói adatok
      </button>
      <button
        onClick={() => onTabChange(2)}
        className={`px-4 py-2 border-t border-l border-r border-gray-300 ${
          activeTab === 2 ? "bg-green-500 text-white" : ""
        }`}>
        Rendelések
      </button>
      <button
        onClick={() => onTabChange(3)}
        className={`px-4 py-2 border-t border-l border-r border-gray-300 ${
          activeTab === 3 ? "bg-green-500 text-white" : ""
        }`}>
        Kedvenc termékek
      </button>
    </div>
  );
};

export default UserTabs;
