import React, { useState, useEffect } from "react";
import OrderCard from "./OrderCard";

const UserOrders = ({ user, onUserUpdated }) => {
  const [ordersList, setOrdersList] = useState(user?.ordersList);
  const [openCardId, setOpenCardId] = useState(null);

  const handleCardClick = (orderId) => {
    setOpenCardId(openCardId === orderId ? null : orderId); // Toggle card open/close
  };
  return (
    <>
      {user && (
        <>
          {ordersList?.map((order, idx) => {
            return (
              <OrderCard
                order={order}
                key={order?._id}
                isOpen={openCardId === order._id}
                onClick={() => handleCardClick(order._id)}
              />
            );
          })}
        </>
      )}
    </>
  );
};

export default UserOrders;
