import React from "react";
import { convertGetDateString } from "@/utils/converDateString";
import icons from "@/assets/icons/icons";
import { currencyDisplayHandler } from "@/utils/currencyDisplay";

const OrderCard = ({ order, isOpen, onClick }) => {
  const {
    deliveryAddress,
    deliveryMethod,
    isCompleted,
    isPacking,
    isUnderDelivery,
    isOuterStore,
    isDeleted,
    orderDate,
    paymentMethod,
    orderData,
  } = order;
  console.log("order", order);
  // Dynamic color based on order status
  const statusColor = isCompleted
    ? "border-green-500"
    : isUnderDelivery
    ? "border-blue-500"
    : isPacking
    ? "border-yellow-500"
    : isOuterStore
    ? "border-gray-500"
    : isDeleted
    ? "boder-red-500"
    : "";

  return (
    <div
      className={`profile__order__card w-full flex flex-col shadow-lg rounded-lg p-6 mb-6 relative light:bg-gradient-to-r light:from-white light:to-gray-50 border-l-4 ${statusColor}`}>
      {/* Header Section */}
      <div
        className="flex justify-between items-center mb-4 cursor-pointer"
        onClick={onClick}>
        <p className="text-gray-500 text-sm font-medium">
          {convertGetDateString(orderDate)}
        </p>
        <span
          className={`transition-transform w-6 h-6 flex items-center justify-center bg-gray-100 rounded-full shadow ${
            isOpen ? "rotate-180" : ""
          }`}>
          {icons.chevronDown}
        </span>
      </div>

      {/* Order Details Section */}
      <div className="grid grid-cols-2 gap-y-4 gap-x-6 border-b pb-4 mb-4">
        <div className="flex flex-col text-base">
          <p className="text-gray-600 font-semibold">Szállítási cím:</p>
          <p className="text-gray-800 font-medium">
            {`${deliveryAddress[0].iranyitoszam.value}, ${deliveryAddress[0].telepules.value}, ${deliveryAddress[0].utca.value}`}
          </p>
        </div>
        <div className="flex flex-col text-base">
          <p className="text-gray-600 font-semibold">Szállítási mód:</p>
          <p className="text-blue-700 font-medium">{deliveryMethod.label}</p>
        </div>
        <div className="flex flex-col text-base">
          <p className="text-gray-600 font-semibold">Fizetési mód:</p>
          <p className="text-green-700 font-medium">{paymentMethod.label}</p>
        </div>
        <div className="flex flex-col text-base">
          <p className="text-gray-600 font-semibold">Rendelés státusza:</p>
          <p className="text-purple-700 font-medium">
            {isPacking
              ? "Csomagolás alatt"
              : isUnderDelivery
              ? "Átadva a szállítónak"
              : isCompleted
              ? "Kézbesítve"
              : isOuterStore
              ? "Külső raktárról"
              : isDeleted
              ? "Törölt rendelés"
              : "Rendelés feladva"}
          </p>
        </div>
      </div>

      {/* "Termékek" Section */}
      {isOpen && (
        <div className="transition-all duration-300 mt-1 pt-2 space-y-2">
          <p className="text-gray-700 font-semibold text-lg">Termékek:</p>
          <ul className="space-y-2">
            {orderData.map((item, index) => {
              return (
                <li
                  key={index}
                  className="w-full flex flex-wrap items-center justify-between border border-gray-200 pb-2 px-2">
                  <ul className="grid grid-cols-2 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-y-2 gap-x-6 text-gray-600 text-sm bg-gray-50 p-3 rounded-lg shadow-sm ">
                    <p className="flex flex-col  text-gray-400">
                      Terméknév:
                      <span className="flex text-[0.90rem] text-gray-600">
                        {item?.item?.parentName}
                      </span>
                    </p>
                    <p className="flex flex-col  text-gray-400">
                      Termékazonosító:
                      <span className="flex text-[0.90rem] text-gray-600">
                        {item?.item?.productItemNumber.value}
                      </span>
                    </p>
                    {item?.item?.productColor?.[0] && (
                      <p className="flex flex-col  text-gray-400">
                        Szín:
                        <span className="flex text-[0.90rem] text-gray-600">
                          {item?.item?.productColor?.[0].colorTitle.value}
                        </span>
                      </p>
                    )}
                    {item?.item?.productSize?.[0] && (
                      <p className="flex flex-col  text-gray-400">
                        Méret:
                        <span className="flex text-[0.90rem] text-gray-600">
                          {item?.item?.productSize?.[0].sizeTitle.value}
                        </span>
                      </p>
                    )}
                    <p className="flex flex-col  text-gray-400">
                      Mennyiség:
                      <span className="flex text-[0.90rem] text-gray-600">
                        {item?.qty} db
                      </span>
                    </p>
                  </ul>
                  <ul className="w-full grid grid-cols-2 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 xl:grid-cols-5 gap-y-2 gap-x-6 text-gray-600 text-sm bg-gray-50 p-3 rounded-lg shadow-sm light:border light:border-gray-200">
                    <p className="flex flex-col  text-gray-400">
                      Nettó ár:
                      <span className="flex text-[0.90rem] text-gray-600">
                        {currencyDisplayHandler(
                          +item?.netto,
                          "hu-HU",
                          "HUF",
                          0
                        )}
                      </span>
                    </p>
                    <p className="flex flex-col  text-gray-400">
                      Bruttó ár:
                      <span className="flex text-[0.90rem] text-gray-600">
                        {currencyDisplayHandler(
                          +item?.brutto,
                          "hu-HU",
                          "HUF",
                          0
                        )}
                      </span>
                    </p>
                    {item?.item?.productDiscount?.value > 0 && (
                      <p className="flex flex-col  text-gray-400">
                        Kedvezmény:
                        <span className="flex text-[0.90rem] text-gray-600">
                          {item?.item?.productDiscount?.value} %
                        </span>
                      </p>
                    )}
                  </ul>
                </li>
              );
            })}
          </ul>
        </div>
      )}
    </div>
  );
};

export default OrderCard;
