import React, { useEffect, useState } from "react";
import { toast } from "react-hot-toast";
import ApiCall from "@/api/api-calls";
import Loader from "@/components/shared/loader/global-loading";
import UserTabs from "./UserTabs";
import UserData from "./UserData";
import UserOrders from "./UserOrders";
import UserFavourites from "./UserFavourites";

const ExpandedUsers = ({ id, token, onUserUpdated }) => {
  const [user, setUser] = useState(null);
  const [activeTab, setActiveTab] = useState(1);
  const [loading, setLoading] = useState(false);

  // get initial user data
  useEffect(() => {
    setLoading(true);
    if (!id) return;

    const fetchUser = async () => {
      try {
        const userElement = await ApiCall.users.getEdit(id);

        if (userElement.status === 200) {
          setUser(userElement?.data);
          //   toast.success(
          //     "Felhasználó sikeresen betöltve: " +
          //     userElement?.data?.data?.productGroupTitle.value
          //   );
        }
      } catch (error) {
        console.error("Error fetching user data:", error);
        toast.error("Hiba a felhasználó betöltésekor: " + error.message);
      } finally {
        setLoading(false);
      }
    };
    fetchUser();
  }, [id, token]);

  console.log("user", user);
  return (
    <div className="w-full my-4">
      <UserTabs activeTab={activeTab} onTabChange={setActiveTab} />
      {activeTab === 1 && user && (
        <UserData user={user} onUserUpdated={onUserUpdated} />
      )}
      {activeTab === 2 && user && (
        <UserOrders user={user} onUserUpdated={onUserUpdated} />
      )}
      {activeTab === 3 && user && (
        <UserFavourites user={user} onUserUpdated={onUserUpdated} />
      )}
    </div>
  );
};

export default ExpandedUsers;
