"use client";

import React from "react";

export function Collapsible({
  title,
  open,
  onToggle,
  children,
}: {
  title: string;
  open: boolean;
  onToggle: () => void;
  children: React.ReactNode;
}) {
  return (
    <div className="rounded-2xl border border-slate-200 bg-white shadow-sm">
      <button
        type="button"
        onClick={onToggle}
        className="flex w-full items-center justify-between px-4 py-3">
        <div className="text-sm font-extrabold">{title}</div>
        <div className="text-xs font-semibold text-slate-500">
          {open ? "Elrejt" : "Megnyit"}
        </div>
      </button>
      {open ? (
        <div className="border-t border-slate-200 p-4">{children}</div>
      ) : null}
    </div>
  );
}
