import React from "react";

const Toast = ({ type, text, handleClose }) => {
  return (
    <div
      className={`fixed top-4 right-4 p-3 rounded-md ${
        type === "error" ? "bg-red-500" : "bg-green-500"
      } text-white shadow-md`}
      style={{
        transform: "translate(-50%, -50%)",
        top: "50%",
        left: "50%",
        zIndex: "9999",
        maxWidth: "300px",
        height: "auto",
      }}>
      <div className="flex items-center justify-between">
        <span>{text}</span>
        <button onClick={handleClose} className="ml-4 text-lg font-semibold">
          ×
        </button>
      </div>
    </div>
  );
};

export default Toast;
