import React, { forwardRef } from "react";

const TextInput = forwardRef(
  ({ label, type, name, defaultValue, onChange, min, max }, ref) => {
    return (
      <>
        <input
          type={type}
          name={name}
          id={name}
          ref={ref}
          defaultValue={defaultValue}
          placeholder={label}
          className="w-full border h-max p-2"
          onChange={onChange}
          {...(min !== undefined && { min })}
          {...(max !== undefined && { max })}
        />
      </>
    );
  }
);
TextInput.displayName = "TextInput";
export default TextInput;
