import React from "react";

const TabSwitcher = ({ data, activeTab, onTabClick }) => {
  return (
    <div className="tab-switcher w-full flex flex-row justify-between items-center">
      {data?.map((d, i) => {
        return (
          <button
            key={i}
            id={d.id}
            className={`w-full text-center px-4 py-2 ${
              activeTab === d.id
                ? "active bg-blue-400 text-white"
                : "border-b border-gray-300"
            }`}
            onClick={() => onTabClick(d.id)}>
            {d.tabTitle}
          </button>
        );
      })}
    </div>
  );
};

export default TabSwitcher;
