import React, { forwardRef } from "react";
import Select from "react-select";

const SelectInput = forwardRef(
  (
    {
      name,
      options,
      defaultValue,
      value,
      placeholder,
      required,
      onChange,
      className = "",
      isMulti,
      isClearable,
    },
    ref
  ) => {
    return (
      <div
        className={`${
          className ?? "flex flex-col w-full mb-4 pb-4 border-b "
        }`}>
        <Select
          options={options}
          name={name}
          ref={ref}
          placeholder={placeholder}
          defaultValue={defaultValue}
          value={value}
          menuPosition="fixed"
          backspaceRemovesValue={false}
          onChange={onChange}
          required={required}
          {...(isMulti !== undefined && { isMulti })}
          {...(isClearable !== undefined && { isClearable })}
        />
      </div>
    );
  }
);
// Add a display name to the component
SelectInput.displayName = "SelectInput";
export default SelectInput;
