import React from "react";
import useSafeHTML from "@/hooks/useSafeHTML";

const SafeHTML = ({ content, maxLength, cls = "" }) => {
  const sanitizedContent = useSafeHTML(content, maxLength);

  return (
    <div
      className={`safe-html-content text-center ${cls}`} // Apply a CSS class
      dangerouslySetInnerHTML={sanitizedContent}
    />
  );
};

export default SafeHTML;
