import React from "react";
import Button from "../button/Button";

const ModalButton = ({ btntext, callback, disabled }) => {
  return (
    <div className="flex flex-row w-full justify-end sticky bottom-0 bg-white p-2 border border-t z-[9999]">
      <Button
        className="px-4 py-2 uppercase border bg-green-500/75 text-white hover:border-green-500 hover:bg-green-500 disabled:bg-gray-500 disabled:pointer-events-none"
        btntext={btntext}
        onClick={callback}
        disabled={disabled}
      />
    </div>
  );
};

export default ModalButton;
