import React, { useEffect, useState } from "react";
import ReactDOM from "react-dom";
import styled from "styled-components";
import icons from "@/assets/icons/icons";
import Link from "next/link";

const Modal = ({ show, onClose, children, title, height, width = "100%" }) => {
  const [isBrowser, setIsBrowser] = useState(false);

  useEffect(() => {
    setIsBrowser(true);
  }, []);

  const handleCloseClick = (e) => {
    e.preventDefault();
    onClose();
  };

  const modalContent = show ? (
    <div className="fixed inset-0 flex flex-row z-50 justify-center items-center bg-gray-800/75 my-2">
      <div
        className={
          "bg-white w-xs-30 rounded overflow-y-auto overflow-x-hidden relative py-2"
        }
        style={{ width: width, maxWidth: "80vw", height: height }}>
        <div className="flex flex-row justify-between sticky top-0 bg-white border-b-gray-300 z-10">
          <div className="w-full h-full p-4">
            {title && (
              <h3
                className="flex flex-wrap font-bold"
                dangerouslySetInnerHTML={{ __html: title }}></h3>
            )}
          </div>
          <div className="h-full border-l-gray-300 p-4 hover:bg-gray-100 hover:fill-red">
            <Link href="#" onClick={handleCloseClick}>
              <span className="flex w-[2rem] h-[2rem]"> {icons.clear}</span>
            </Link>
          </div>
        </div>
        <div className="h-max">{children}</div>
      </div>
    </div>
  ) : null;

  if (isBrowser) {
    return ReactDOM.createPortal(
      modalContent,
      document.getElementById("modal-root")
    );
  } else {
    return null;
  }
};

export default Modal;
