// components/ImagePicker.js
import React from "react";
import { useDispatch } from "react-redux";
import { editorActionMap } from "store/editorActionMap";
import Image from "next/image";
const ImagePicker = ({ type = "featured", images = [] }) => {
  const dispatch = useDispatch();

  const handleImageSelect = (image) => {
    const handler = editorActionMap.imageSelection?.[type];
    if (handler) {
      handler(dispatch, image);
    } else {
      console.warn(`No image handler found for type: "${type}"`);
    }
  };

  return (
    <div className="image-picker">
      {images.map((image) => (
        <button key={image.id} onClick={() => handleImageSelect(image)}>
          <Image src={image.url} alt={image.name} width={100} height={100} />
        </button>
      ))}
    </div>
  );
};

export default ImagePicker;
