import React, { useState } from "react";
import { library, dom } from "@fortawesome/fontawesome-svg-core";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { fas } from "@fortawesome/free-solid-svg-icons";

// Call this to initialize the library
library.add(fas);
dom.watch(); // This will add the CSS to the page

const IconPicker = () => {
  const [searchTerm, setSearchTerm] = useState("");

  const filteredIcons = Object.keys(fas).filter((iconName) =>
    iconName.toLowerCase().includes(searchTerm.toLowerCase())
  );

  return (
    <>
      <input
        type="text"
        placeholder="Search icons..."
        value={searchTerm}
        onChange={(e) => setSearchTerm(e.target.value)}
      />
      <div className="flex flex-row flex-wrap">
        {filteredIcons.map((iconName) => {
          return (
            <div key={iconName}>
              <FontAwesomeIcon icon={fas[iconName]} width={35} height={35} />
            </div>
          );
        })}
      </div>
    </>
  );
};

export default IconPicker;
