// IconList.js
import React, { useState } from "react";
import PropTypes from "prop-types";

const IconList = ({ icons, onSelect }) => {
  const [searchTerm, setSearchTerm] = useState("");

  const filteredIcons = Object.entries(icons).filter(([key]) =>
    key.toLowerCase().includes(searchTerm.toLowerCase())
  );

  return (
    <div>
      <input
        type="text"
        className="border w-full mb-2 p-2"
        placeholder="Search icons"
        value={searchTerm}
        onChange={(e) => setSearchTerm(e.target.value)}
      />
      <div className="w-full flex flex-row flex-wrap">
        {filteredIcons.map(([key, icon]) => (
          <div
            key={key}
            onClick={() => onSelect(key)}
            className="flex w-[2rem] h-[2rem] mr-2 mb-2 border border-gray-400 cursor-pointer">
            {icon}
          </div>
        ))}
      </div>
    </div>
  );
};

IconList.propTypes = {
  icons: PropTypes.object.isRequired,
  onSelect: PropTypes.func.isRequired,
};

export default IconList;
