import React, { useMemo } from "react";
import Link from "next/link";

const SubHeaderComponent = ({
  actions = [],
  showSearch = false,
  onSearchChange = () => {},
}) => {
  const renderActions = useMemo(() => {
    return actions.map((action, index) => (
      <Link href={action?.url} as={action?.url} key={index}>
        <button
          variant={action.variant || "contained"}
          color={action.color || "primary"}
          onClick={action.onClick}
          style={action.style || { margin: "5px" }}>
          {action.label}
        </button>
      </Link>
    ));
  }, [actions]);

  return (
    <div style={{ display: "flex", alignItems: "center" }}>
      {renderActions}
      {showSearch && (
        <input
          id="outlined-basic"
          label="Search"
          variant="outlined"
          size="small"
          style={{ margin: "5px" }}
          onChange={(e) => onSearchChange(e)}
        />
      )}
    </div>
  );
};

export default SubHeaderComponent;
