import styled from "styled-components";

const TextField = styled.input`
  height: 32px;
  width: 200px;
  border-radius: 3px;
  border-top-left-radius: 5px;
  border-bottom-left-radius: 5px;
  border-top-right-radius: 0;
  border-bottom-right-radius: 0;
  border: 1px solid #e5e5e5;
  padding: 0 32px 0 16px;

  &:hover {
    cursor: pointer;
  }
`;

export const FilterComponent = ({ filteredText, onFilter, onClear, icon }) => (
  <>
    <TextField
      id="search"
      type="text"
      placeholder="Keresés név alapján"
      aria-label="Search Input"
      value={filteredText}
      onInput={onFilter}
    />
    <button
      type="button"
      onClick={onClear}
      icon={icon}
      className={
        "pl-2 fill-indigo-400/75 hover:fill-indigo-400 w-[2rem] h-[2rem]"
      }>
      {icon}
    </button>
  </>
);
