"use client";
import React from "react";
import DataTable from "react-data-table-component";

const selectProps = { indeterminate: (isIndeterminate) => isIndeterminate };

function DataTableBase(props) {
  // Default context message for row selection
  const contextMessage = {
    singular: "elem kiválasztva",
    plural: "elem kiválasztva",
    // message: `${props.selectedRows?.length || 0} elem kiválasztva`,
  };
  return (
    <DataTable
      defaultSortFieldId={props.defaultSortFieldId || 1}
      actions={props.actions}
      selectableRows
      striped
      responsive
      highlightOnHover={props.highlightOnHover || true}
      pagination
      paginationServer
      paginationPerPage={props.paginationPerPage || 25}
      paginationRowsPerPageOptions={[25, 50, 75, 100]}
      paginationTotalRows={props.paginationTotalRows}
      dense
      fixedHeader={props.fixedHeader || false}
      fixedHeaderScrollHeight={props.fixedHeaderScrollHeight || "300px"}
      direction="auto"
      expandOnRowClicked={props.expandOnRowClicked || false}
      expandableRows={props.expandableRows || false}
      expandableRowsHideExpander={props.expandableRowsHideExpander || false}
      subHeader={props.subHeader || false}
      subHeaderComponent={props.subHeaderComponent || null} // Pass subHeaderComponent
      subHeaderAlign={props.subHeaderAlign || "right"}
      subHeaderWrap={props.subHeaderWrap || true}
      contextActions={props.contextActions}
      persistTableHead={props.persistTableHead || false}
      progressPending={props.progressPending || false}
      selectableRowsHighlight={props.selectableRowsHighlight || false}
      selectableRowsSingle={props.selectableRowsSingle || false}
      disabled={props.disabled || false}
      onSort={props.onSort || null} // Pass sort handler
      onSearch={props.onSearch || null} // Pass search handler
      paginationComponentOptions={props.paginationOptions}
      onChangePage={props.onChangePage}
      contextMessage={props.contextMessage || contextMessage} // Pass context message
      {...props}
    />
  );
}

export default DataTableBase;
