import React from "react";
import ColorPickerComponent from "@/components/shared/colorpicker/ColorPickerComponent";

const ColorField = ({ label, value, onChange }) => (
  <div className="flex flex-row w-full mb-4 pb-4 border-b">
    <label className="w-1/4 text-gray-400 pr-2">
      <p className="font-bold">{label}</p>
    </label>
    <ColorPickerComponent value={value} onChange={onChange} />
  </div>
);

export default ColorField;
