const ControlButton = ({ icon, onClick, color = "gray", title }) => {
  const baseStyle =
    "w-8 h-8 flex items-center justify-center rounded-md bg-white border border-gray-200 shadow-sm transition hover:scale-105";

  const colorMap = {
    red: "text-red-500 hover:text-red-600 hover:border-red-300",
    green: "text-green-500 hover:text-green-600 hover:border-green-300",
    gray: "text-gray-500 hover:text-gray-700 hover:border-gray-300",
  };

  return (
    <button
      className={`${baseStyle} ${colorMap[color]}`}
      onClick={onClick}
      title={title}
      type="button">
      {icon}
    </button>
  );
};
export default ControlButton;
// const ControlButton = ({ icon, color, hoverColor, onClick }) => (
//   <span
//     className={`flex w-[2.5rem] h-[2.5rem] justify-center items-center fill-${color}-500/50 hover:fill-${
//       hoverColor || color
//     }-500 mb-4`}
//     onClick={onClick}>
//     {icon}
//   </span>
// );

// export default ControlButton;
