import { Draggable } from "react-beautiful-dnd";
import icons from "@/assets/icons/icons";

export const Drag = ({ id, index, ...props }) => {
  return (
    <Draggable draggableId={id} index={index}>
      {(provided, snapshot) => {
        return (
          <div
            ref={provided.innerRef}
            {...provided.draggableProps}
            {...props}
            className="flex flex-row my-4">
            <div
              className="drag-handle !p-2 !bg-blue-400 w-[2rem] h-[2rem] m-1"
              {...provided.dragHandleProps}>
              {icons.move}
            </div>
            {props.children}
          </div>
        );
      }}
    </Draggable>
  );
};
